# CMSampleBuffer

###### Documentations:

[Apple](https://developer.apple.com/documentation/coremedia/cmsamplebuffer-u71)

###### Samples

One CMSampleBuffer can have (and mostly has) more than one sample. 
> The nuRmber of samples can be zero.
The number of media samples is represented in the numSamples property.

###### Timing

Each sample can have a time describing it. The sample timing is a number which describes when the sample should be played out.
These properties describe the timing, they are called output presentation timestamp.
> outputPTS
> PTS
outputPTS or PTS with 0/44100 are allowed and it seems that they are not played out.

The full timing informations can be found under the following properties:
> numSampleTimingEntries - Number of entries in sampleTimingArray. Must be 0, 1, or numSamples.
> sampleTimingArray  - Array of CMSampleTimingInfo structs, one struct per sample.

IMPORTANT for sampleTimingArray:
> ... If all samples have the same duration and are in presentation order, you can pass a single CMSampleTimingInfo struct with duration set to the duration of one sample ...

A single element sampleTimingArray will look like this:
```
...
sampleTimingArray[1] = ...
..
```
NOTE:  ```numSampleTimingEntries``` will not be seen in the console.

Console: 
```
numSamples = 16384
outputPTS = {0/44100 = 0.000}(based on cachedOutputPresentationTimeStamp)
sampleTimingArray[1] = 
{
    {PTS = {0/44100 = 0.000}, DTS = {INVALID}, duration = {1/44100 = 0.000}},
}
```
```
numSamples = 16384
outputPTS = {16384/44100 = 0.372}(based on cachedOutputPresentationTimeStamp)
sampleTimingArray[1] = {
    {PTS = {16384/44100 = 0.372}, DTS = {INVALID}, duration = {1/44100 = 0.000}},
}
```

The duration is set to the duration of one sample.
> The presentationTimeStamp is the presentation time of the numerically earliest sample.

The player will read the sample timing in the following playout time (order):
[ 1 / 44100 , 2 / 44100, ...  , 16384 / 44100]

CMSampleBufferCreateCopyWithNewTiming is used to change the timing properties. A new sample buffer is created with the new modified timing. The old one can be released.

