//**********************************************************************************************************************
//
//  BXLogSniffer.h
//
//  Author:		Peter Baumgartner, peter@baumgartner.com
//  Copyright:	©2015 by IMAGINE GbR. All rights reserved.
//	Abstract:	Class that intercepts all logging to stderr
//
//**********************************************************************************************************************


#pragma mark HEADERS

#import <Foundation/Foundation.h>


//----------------------------------------------------------------------------------------------------------------------


#pragma mark TYPES

@class BXLogSniffer;

typedef void (*BXLogSnifferCallbackFunction)(BXLogSniffer* inLogSniffer,char* inBytes,size_t inLength);


//----------------------------------------------------------------------------------------------------------------------


@interface BXLogSniffer : NSObject
{
//	int _origStdErrFD;
	int _pipeFD[2];
	char* _buffer;
}

+ (instancetype) sharedLogSniffer;

@property (nonatomic,assign) int origStdErrFD;
@property (nonatomic,assign) BXLogSnifferCallbackFunction callback;

- (void) finishLogging;

@end


//----------------------------------------------------------------------------------------------------------------------
