#  AudioEngine documentation.

The general design of the audio graph im mimoLive looks like this:

											   I              O
		   InputSubgraph----EffectsSubgraph----|¯¯¯¯¯¯¯¯¯¯¯¯¯¯|----MasterEffects----GenericOutput----RingBuffer----OutputDispatcher (Master Mix for streaming, recording, playout)
		   InputSubgraph----EffectsSubgraph----|              |----SubmixEffects----Ringbuffer-------AudioOutputDevices (AUHAL Audio Units)
											   . Matrix Mixer .
											   .              .
		   InputSubgraph----EffectsSubgraph----|______________|----SubmixEffects----Ringbuffer

		   How audio data travels to the Matrix Mixer:
																									I					O
		   -[AudioData]----TVSource----(TVAudioProviderDelegate)InputSubgraph----EffectsSubgraph----[ 	Matrix Mixer 	]----...

		   We cannot use AUHAL for the input directly, as only one OutputAU is allowed per Graph.
		   (Yes, before you ask, AUHAL is an OutputAU that does input AND output.)
		   
		   InputSubgraph: Not every input subgraph uses an effects subgraph. See the input subgraph base class for details on how input works.
		   MasterEffects: The master effects only consist of one master bus compressor.
		   SubmixEffects: The submix effects only consist of one master bus compressor.


		   Documentation: http://developer.apple.com/documentation/MusicAudio/Reference/CoreAudio/CoreAudio.pdf
		   https://the-eye.eu/public/Books/IT%20Various/learning_core_audio.pdf

### TVAudioGraph
type: class
ofClass: NSObject

* Handles building an audio graph, connecting inputs and outputs, mixing signals and providing several outputs of rendered audio data.
* The TVAudioGraph interface should only be called by top level classes like TVDocument, TVAppDelegate, ... to create, configure, query and destroy a TVAudioGraph object.
* Generally, all other classes should make use of the TVAudioMasterGraph protocol which exposes TVAudioGraph's work API.
* TVAudioMasterGraph will be referenced as:
	* audioEngine (for all future uses).
	* audioMixer (kept for historical reasons).
Examples: 
	* TVOutputDispatcher.m -> self.audioEngine. 
	* TVRTSPSource.m -> self.audioEngine.
	* ...

* The audio engine connects sources to appropriate TVAudioInputSubgraphs.

### TVAudioMasterGraph
type: protocol

* Exposes internal methods of audioEngine (TVAudioGraph) for easier access by consumers.
* Containst 5 API types:
	* Subgraph Service API
	* Sources Service API
	* Mix Management API
	* Recording Service API
	* Output Device API

### TVAudioSubgraph
type: protocol

### TVAudioInputSubgraph
type: class
ofClass: NSObject

### TVDeviceAudioSourceGenericSubgraph
type: class
ofClass: TVAudioInputSubgraph

### TVAudioOutputDevice
type:
ofClass: 
