# AVSampleBufferRenderSynchronizer

###### Documentations:

[Apple](https://developer.apple.com/documentation/avfoundation/avsamplebufferrendersynchronizer)

###### General
This class has a AVSampleBufferRenderSynchronizer which holds one AVSampleBufferAudioRenderer. They have a relationship 1to1. A AVSampleBufferRenderSynchronizer can have more than one AVSampleBufferAudioRenderer. The intent of this class was not to offer advanced mixing and synchornising by using more AVSampleBufferAudioRenderer.

###### Timing

There are two values which deal with timing:
1.  ```var timebase: CMTimebase
2.  ```func currentTime() -> CMTime

```
Timebase = FigTimebase: 0x102405cd0 (ReadOnly) 
    targetTimebase: 0x102405b80 
    retainCount: 5 allocator: 0x7fff860928c0 
    master timebase: 0x0 
    rate: 1.000000 
    time: {398674211/1000000000 = 0.399} = 0.398674 seconds

Current time = CMTime(value: 398704662, 
    timescale: 1000000000, 
    flags: __C.CMTimeFlags(rawValue: 1), 
    epoch: 0)
```

###### Rate

The rate property was constant while the synchronizer tried to "catch up" to rendering time changes.
The internal rendering time has no influence on playout rate.

