
### Timing

The ```AVSampleBufferRenderSynchronizer```  has its own rendering time. The rendering time it uses is the ```AVSampleBufferAudioRenderer```   renderer time (if there is any AVSampleBufferAudioRenderer attached).
The sample buffers the ```AVSampleBufferAudioRenderer``` plays out have their own rendering time.

Delta is the difference between the ```AVSampleBufferAudioRenderer``` and ```CMSampleBuffer``` render times.

Our goal is the playout frames from the near past. The near past means that we actually have those frames scheduled inside a buffer and ```AVSampleBufferAudioRenderer```s render time is slightly ahead. Delta should be in the range of 0.0 to 0.3 .
The first case where delta is lower than 0.0 will result in no playout.
The second case where delta is positive will result in a delayed playback.

When the delta is within the ranges of 0.0 to 0.3 we experience smooth playback.

###### Queues

There are two queues in use:
1. The sample enqueue queue - sampleEnqueueQueue.
The sampleEnqueueQueue has only one purpose, to enqueue new samples.
2. The update properties queueu - updateStateQueue.
The updateStateQueue will be used to update all AVSampleBufferAudioRenderer and AVSampleBufferRenderSynchronizer properties.
Due a bug in Apple code (see Apple_Bug_BXAudioSampleBufferSerializer_Stack_Trace_0.png) changing two properties at the same time blocks the latest thread.
Each property change needs to be done separate with a serial queue.

WARNING: Always ensure that updateStateQueue does only status updates, e.g. property changes. Changing properties on the main thread will lock the main thread.
Switching from any thread to updateStateQueue is allowed because it is mostly done async(). For sync() switching see and read Queues (1).

###### Queues (1)
The sampleEnqueueQueue switches to the updateStateQueue synchronously because the setRate(_: _:) method recevies a timestamp which stops being valid if the timestamp is set via a async() call in some future.
This still works because there are only a handfull of updateStateQueue tasks available at any given time.
