//**********************************************************************************************************************
//
//  BXPresetPopupButton.h
//
//  Author:		Peter Baumgartner, peter@baumgartner.com
//  Copyright:	©2004-2011 by IMAGINE GbR. All rights reserved.
//	Abstract:	Small popup button that lists presets, also saves and load them.
//
//**********************************************************************************************************************


@interface BXPresetPopupButton : NSPopUpButton
{
    IBOutlet id _delegate;
    NSString* _presetFolderPath;
    NSString* _imageName;
    BOOL _hasSavePresetMenuItem;
    BOOL _hasEditPresetsMenuItem;
    BOOL _hasCustomMenuItem;
}

@property (assign) id delegate;
@property (retain) NSString* presetFolderPath;
@property (retain) NSString* imageName;

@property (assign) BOOL hasSavePresetMenuItem;
@property (assign) BOOL hasEditPresetsMenuItem;
@property (assign) BOOL hasCustomMenuItem;

- (IBAction) loadPreset:(id)inSender;
- (IBAction) savePreset:(id)inSender;
- (IBAction) editPresets:(id)inSender;

- (NSArray*) presetPaths;
- (void) updateMenu;
- (void) selectCustomMenuItem;
- (void) selectMenuItemForPresetAtPath:(NSString*)inPath;
- (void) selectMenuItemForCurrentSettings;

@end


//----------------------------------------------------------------------------------------------------------------------


#pragma mark

// Delegate objects must implement this method and return a dictionary for keypath/value 
// pairs so that a preset can be saved...

@protocol BXPresetPopupButtonDelegate

- (NSDictionary*) savePresetToDictionary;
- (void) loadPresetFromDictionary:(NSDictionary*)inPreset;

@end


//----------------------------------------------------------------------------------------------------------------------
