//**********************************************************************************************************************
//
//  BXScroller.h
//
//  Author:		Peter Baumgartner, peter@baumgartner.com
//  Copyright:	©2009-2011 by IMAGINE GbR. All rights reserved.
//	Abstract:	Scroller with customizable procedural drawing. Uses BXCachedDrawing.
//
//
//  Open Todos: 
//         - themes
//         - invalidate caches
//         - shadow for knob
//         - live arrow config switching
//         - full resolution independence
//         - cached know drawing
//         - cached track drawing
//
//**********************************************************************************************************************


#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_5

#pragma mark CONSTANTS

enum
{
    kBXScrollerThemeGray		= 0,
    kBXScrollerThemeLightGray	= 1,
    kBXScrollerThemeDarkGray	= 2,
    kBXScrollerThemeiTunes	 	= 3,
    kBXScrollerThemeiMovie	 	= 4,
    kBXScrollerThemeiTunesDark 	= 5,
    kBXScrollerThemeChameleon 	= 6,

    kBXScrollerThemeDefault		= kBXScrollerThemeGray
};

typedef NSUInteger BXScrollerTheme;


//----------------------------------------------------------------------------------------------------------------------


#pragma mark

@interface BXScroller : NSScroller
{
	BXScrollerTheme _theme;
	NSColor* _chameleonColor;
	
	NSGradient *_trackGradient;
	CGFloat _capLength;
	
	NSGradient *_buttonNormalGradient;
	NSGradient *_buttonPushedGradient;
	NSColor *_buttonStrokeColor;
	NSColor *_buttonDividerColor;
	NSColor *_buttonShadowColor;
	NSColor *_arrowColor;
	NSShadow *_arrowShadow;
	
	NSGradient *_knobGradient;
	NSColor *_knobStrokeColor;
	CGFloat _knobLineWidth;
	CGFloat _knobInset;
	
	// Geometry...
	
	BOOL _doubleMin;
	BOOL _doubleMax;

	// Cached layers...
	
	CGLayerRef _leftCap;
	CGLayerRef _rightCap;
	CGLayerRef _topCap;
	CGLayerRef _bottomCap;

	CGLayerRef _singleLeftNone;
	CGLayerRef _singleLeftDec;
	CGLayerRef _doubleLeftNone;
	CGLayerRef _doubleLeftDec;
	CGLayerRef _doubleLeftInc;

	CGLayerRef _singleRightNone;
	CGLayerRef _singleRightInc;
	CGLayerRef _doubleRightNone;
	CGLayerRef _doubleRightDec;
	CGLayerRef _doubleRightInc;

	CGLayerRef _singleTopNone;
	CGLayerRef _singleTopDec;
	CGLayerRef _doubleTopNone;
	CGLayerRef _doubleTopDec;
	CGLayerRef _doubleTopInc;

	CGLayerRef _singleBottomNone;
	CGLayerRef _singleBottomInc;
	CGLayerRef _doubleBottomNone;
	CGLayerRef _doubleBottomDec;
	CGLayerRef _doubleBottomInc;
	
	BOOL themeLoaded;
}

@property (assign) BXScrollerTheme theme;
@property (retain) NSColor* chameleonColor;
+ (BOOL) useCustomTheme;
- (void)initGeometry;
- (void) initTheme;

@property (retain) NSGradient * trackGradient;
@property CGFloat capLength;

@property (retain) NSGradient * buttonNormalGradient;
@property (retain) NSGradient * buttonPushedGradient;
@property (retain) NSColor * buttonStrokeColor;
@property (retain) NSColor * buttonDividerColor;
@property (retain) NSColor * buttonShadowColor;
@property (retain) NSColor * arrowColor;
@property (retain) NSShadow * arrowShadow;

@property (retain) NSGradient * knobGradient;
@property (retain) NSColor * knobStrokeColor;
@property CGFloat knobLineWidth;
@property CGFloat knobInset;
	
@end


#endif

//----------------------------------------------------------------------------------------------------------------------
