//
//  BXLicenseSheetController.h
//  Boinx Services Framework
//
//  Created by Michael Ehrmann on Fri Mar 05 2004.
//  Copyright (c) 2004 GeBE Computer & Peripherie GmbH. All rights reserved.
//

@import Cocoa;

@class BXLicenseKey;

@interface BXLicenseSheetController : NSWindowController {
    
    IBOutlet NSButton* okButton;
    IBOutlet NSButton* cancelButton;
    
    IBOutlet NSTextField* licenseNameTextField;
    IBOutlet NSTextField* licenseOrganisationTextField;
    IBOutlet NSTextField* licenseKeyTextField;
    IBOutlet NSTextField* licenseStatusTextField;
	IBOutlet NSTextField* licenseTypeTextField;
    
    BXLicenseKey *currentLicenseKey;

    NSString *oldName;
    NSString *oldOrganisation;
    NSString *oldKey;
	
	id _internalFieldEditor;
	
	BOOL canAddOldLicenses;
	NSButton *showInFinderButton;
}

@property (nonatomic, assign) IBOutlet NSButton *showInFinderButton;

+ (void) showModifyLicenseSheetForLicense:(BXLicenseKey*)tmpLicense modalForWindow:(NSWindow*)parentWindow;

+ (void) showAddLicenseSheetModalForWindow:(NSWindow*)parentWindow;
+ (void) showAddLicenseSheetModalForWindow:(NSWindow*)parentWindow supportsOldVersions:(BOOL)inSupportsOldVersions showMessage:(BOOL)inShowMessage;

- (void) awakeFromNib;
- (void) windowDidLoad;
- (void) updateWindow;

- (IBAction) showLicenseSheet:(id)sender;
- (IBAction) cancelLicenseSheet:(id)sender;
- (IBAction) saveLicenseSheet:(id)sender;
- (IBAction)showLicenseInFinder:(id)sender;

- (void) controlTextDidChange:(NSNotification *)aNotification;

- (void)useValuesFromLicenseKey:(BXLicenseKey *)inLicenseKey;
- (void)useValuesFromLicenseKeyDict:(NSDictionary *)inLicenseKeyDict;

- (BOOL)checkCode;

- (void) setCurrentLicenseKey:(BXLicenseKey*)value;
- (BXLicenseKey*) currentLicenseKey;

- (BOOL)canAddOldLicenses;
- (void)setCanAddOldLicenses:(BOOL)flag;

@end
