//**********************************************************************************************************************
//
//  BXAlertPopover.h
//
//  Author:		Peter Baumgartner, peter@baumgartner.com
//  Copyright:	©2011 by IMAGINE GbR. All rights reserved.
//	Abstract:	Subclass for alert popovers
//
//**********************************************************************************************************************


#pragma mark HEADERS

#import <BXAppKit/BXPopover.h>
#import <BXAppKit/BXAlertPopoverViewController.h>


//----------------------------------------------------------------------------------------------------------------------


@interface BXAlertPopover : BXPopover

// Convienience methods...

+ (BXAlertPopover*) stopPopoverWithHeader:(NSString*)inHeader body:(NSString*)inBody footer:(NSString*)inFooter;
+ (BXAlertPopover*) warningPopoverWithHeader:(NSString*)inHeader body:(NSString*)inBody footer:(NSString*)inFooter;
+ (BXAlertPopover*) notePopoverWithHeader:(NSString*)inHeader body:(NSString*)inBody footer:(NSString*)inFooter;

// Designated initializer...

+ (BXAlertPopover*) alertPopoverWithIcon:(NSImage*)inIcon header:(NSString*)inHeader body:(NSString*)inBody footer:(NSString*)inFooter;
- (id) initWithIcon:(NSImage*)inIcon header:(NSString*)inHeader body:(NSString*)inBody footer:(NSString*)inFooter;

// Access to contentViewController

@property (strong) IBOutlet BXAlertPopoverViewController *contentViewController;

// Icon...

@property (strong) NSImage* icon;

// Optional buttons...

- (void) addButtonWithTitle:(NSString*)inTitle block:(BXButtonBlockType)inBlock;

// Custom text colors...

- (void) setHeaderTextColor:(NSColor*)inColor;
- (void) setBodyTextColor:(NSColor*)inColor;
- (void) setFooterTextColor:(NSColor*)inColor;

// Optional progress wheel...

- (void) showProgressIndicator;
- (void) hideProgressIndicator;

@end


//----------------------------------------------------------------------------------------------------------------------
