//**********************************************************************************************************************
//
//  BXProgressSheet.h
//
//  Author:		Peter Baumgartner, peter@baumgartner.com
//  Copyright:	©2008-2016 by IMAGINE GbR. All rights reserved.
//	Abstract:	Displays generic progress panels as a sheet
//
//**********************************************************************************************************************


@interface BXProgressSheet : NSWindowController

// Creating a progress sheet...

+ (BXProgressSheet*) sharedProgressSheet;
+ (BXProgressSheet*) progressSheetWithTitle:(NSString*)inTitle;
- (id) initWithTitle:(NSString*)inTitle;

// Properties...

@property (assign,getter=isIndeterminate) BOOL indeterminate;
@property (nonatomic,strong) NSString* titleString;
@property (nonatomic,strong) NSString* detailString;
@property (nonatomic,assign) double minValue;
@property (nonatomic,assign) double maxValue;
@property (nonatomic,assign) double value;

// Add Cancel button...

- (void) addCancelButton:(dispatch_block_t)inCancelBlock;

// Showing and hiding the sheet...

- (void) show;
- (void) showModally:(BOOL)inModal;
- (void) hide;

- (void) beginSheetForWindow:(NSWindow*)inWindow;
- (void) endSheet;

+ (BOOL) isVisible;
+ (BOOL) isModal;

// Update the UI...

- (void) display;

@end


//----------------------------------------------------------------------------------------------------------------------
