/*

 Owner: Michael Ehrmann <michael@boinx.com>
 Company: Boinx Software Ltd., Germany
 Projects: BXBase

 Abstract: Support for application wide Application Support directories.	

 */


FOUNDATION_EXPORT NSArray * BXApplicationSupportPathsInDomains(NSSearchPathDomainMask domainMask, BOOL expandTilde); // return e.g. "~/Library/Application Support/Boinx/"

@interface NSApplication (BXApplicationSupport)

- (NSArray *)pathsForApplicationSupportFolderInDomains:(NSSearchPathDomainMask)inSearchPathDomainMask; // return e.g. "~/Library/Application Support/Boinx/" + ExecutableName
- (NSString *)pathForExistingItemInApplicationSupportPath:(NSString *)inApplicationSupportSubpath inDomains:(NSSearchPathDomainMask)inSearchPathDomainMask;

- (BOOL)writeData:(NSData *)inData toUserApplicationSupportPath:(NSString *)inApplicationSupportSubpath error:(NSError **)outError;
- (BOOL)writeData:(NSData *)inData toLocalApplicationSupportPath:(NSString *)inApplicationSupportSubpath error:(NSError **)outError;
- (BOOL)writeData:(NSData *)inData toNetworkApplicationSupportPath:(NSString *)inApplicationSupportSubpath error:(NSError **)outError;

- (BOOL)writeData:(NSData *)inData toApplicationSupportPath:(NSString *)inApplicationSupportSubpath inDomains:(NSSearchPathDomainMask)inSearchPathDomainMask error:(NSError **)outError;

@end
