//**********************************************************************************************************************
//
//	NSString+VersionCompare.h
//
//	Author:		Peter Baumgartner, peter@baumgartner.com
//	Copyright:	©2010-2011 by IMAGINE GbR. All rights reserved.
//	Abstract:	Method for comparing version strings
//
//**********************************************************************************************************************


@interface NSString (BXVersionCompare)

/**
 * Compares two version string including suffix + number
 * 1.4b1 < 1.4
 * The letter order is d,a,b,fc
 */
+ (NSComparisonResult) compareVersion:(NSString*)inVersionA withVersion:(NSString*)inVersionB;

/**
 * compages two versions
 * 1.4b = 1.4 if inIgnoreLetter = YES
 */
+ (NSComparisonResult)compareVersion:(NSString*)inVersionA withVersion:(NSString*)inVersionB ignoreLetters:(BOOL)inIgnoreLetters;

@end


//----------------------------------------------------------------------------------------------------------------------

