//**********************************************************************************************************************
//
//  BXColorWheel.h
//
//  Author:		Peter Baumgartner, peter@baumgartner.com
//  Copyright:	©2008-2011 by IMAGINE GbR. All rights reserved.
//	Abstract:	Intuitive color wheel control for choosing white balance factors
//
//**********************************************************************************************************************


#pragma mark CONSTANTS

enum BXColorWheelMouseOperation
{
    kColorWheelOperationNone,
    kColorWheelOperationDrag
};


//----------------------------------------------------------------------------------------------------------------------


#pragma mark


@interface BXColorWheel : NSView
{
    // Properties...
    
    BOOL _enabled;
    double _whiteBalance[3];
    BOOL _multipleValues[3];
    BOOL _noValue[3];
    
    // Datafields...
    
    NSImage* _colorWheel;
    NSColor* _frameColor[2];
    NSColor* _knobColor[2];
	NSShadow* _dropShadow;
    NSMutableDictionary* _bindingInfo;

    double _radius;
    NSRect _wheelFrame;
    NSPoint _knobPoint;
    NSPoint _mouseDownPoint;
    NSInteger _mouseOperation;
    NSPoint _knobAtMouseDown;
}

// Properties...

@property BOOL enabled;
@property double redFactor;
@property double greenFactor;
@property double blueFactor;


@end


//----------------------------------------------------------------------------------------------------------------------
