//
//  BXLicenseWindowController.h
//  Boinx Services Framework
//
//  Created by Michael Ehrmann on Wed May 19 2004.
//  Copyright (c) 2004  GeBE Computer & Peripherie GmbH. All rights reserved.
//

@import Cocoa;

@interface BXLicenseWindowController : NSWindowController
{
    IBOutlet NSView *contentView;
    IBOutlet id detailView;
	
	IBOutlet NSTableView *licenseTableView;
	IBOutlet id removeLicenseButton;
	IBOutlet id addLicenseButton;
	IBOutlet id modifyLicenseButton;
	IBOutlet id printLicenseButton;
	
	IBOutlet id programmStatusTextField;	
	IBOutlet id programmStatusDetailTextField;
}

- (IBAction)addLicense:(id)sender;
- (IBAction)addOrPasteLicense:(id)sender;
- (IBAction)modifyLicense:(id)sender;
- (IBAction)removeLicense:(id)sender;
- (IBAction)printLicenseCertificate:(id)sender;
- (IBAction)getLicense:(id)sender;


- (void)licenseListChanged:(NSNotification*)notification;
- (void)tableViewSelectionDidChange:(NSNotification *)notification;

- (IBAction)showWindow:(id)sender;
- (IBAction)hideWindow:(id)sender;
- (IBAction)showWindowAsSheet:(id)sender;
- (IBAction)closeSheet :(id)sender;

- (IBAction)showDetails:(id)sender;

- (void)updateWindow;
- (void)savePrefs;

- (void)windowDidBecomeKey:(NSNotification *)aNotification;
- (void)windowDidResignKey:(NSNotification *)aNotification;
- (BOOL)windowShouldClose:(id)sender;

@end
