/*
	Owner:		Nicholas Shanks <nicholas@boinx.com>
	Company:	Boinx Software, Germany
	Abstract:	Draws an NSButtonCell with a shadow under the title.
	Related:	BXEmbossedButton
*/

@interface BXEmbossedButtonCell : NSButtonCell
{
	NSColor *_textColor;
	NSColor *_shadowColor;
	NSShadow* _shadow;
	BOOL _prefersLightShadow;			// uses +[NSColor highlightColor] for grey text; use on dark backgrounds
	BOOL _drawsShadowWhenDisabled;		// disabled text fields have a shadow too (default is no shadow)
	BOOL _usesHalfAlphaWhenDisabled;	// use textColor with 50% alpha for disabled text, instead of +disabledControlTextColor; use for mid-grey backgrounds
}

- (NSColor *)textColor;
- (void)setTextColor:(NSColor *)inColor;

- (BOOL)prefersLightShadow;
- (void)setPrefersLightShadow:(BOOL)flag;
- (BOOL)drawsShadowWhenDisabled;
- (void)setDrawsShadowWhenDisabled:(BOOL)flag;
- (BOOL)usesHalfAlphaWhenDisabled;
- (void)setUsesHalfAlphaWhenDisabled:(BOOL)flag;

- (NSColor *)shadowColor;
- (void)setShadowColor:(NSColor *)inColor;
- (NSColor *)shadowColorForTextColor:(NSColor *)inColor;

@end
