//**********************************************************************************************************************
//
//  BXSandboxingUtils.h
//
//  Author:		Peter Baumgartner, peter@baumgartner.com
//  Copyright:	©2012 by Boinx Software, Ltd. All rights reserved.
//	Abstract:	Runtime checks for sandboxing environment
//
//**********************************************************************************************************************


// Returns YES if the app is running in a sandbox...

BOOL BXIsSandboxed(void);

// Replacement function for NSHomeDirectory: Always return the REAL home directory of the current
// user, even if the app is sandboxed...

NSString* BXHomeDirectory(void);

// Convenience function for getting a path to an application container directory. Returns the home
// directory of a given sandboxed app container. Use nil for the current application...

NSString* BXApplicationContainerHomeDirectory(NSString* inBundleIdentifier);

// High level function that should be used instead of CFPreferencesCopyAppValue, because in  
// sandboxed apps we need to work around problems of CFPreferencesCopyAppValue returning NULL...
 
CFTypeRef BXPreferencesCopyAppValue(CFStringRef inKey,CFStringRef inBundleIdentifier);


//----------------------------------------------------------------------------------------------------------------------
