//
//  NSBundle+InfoPlist.h
//  BXFoundation
//
//  Created by alex on 25.07.13.
//  Copyright (c) 2013 Boinx Software Ltd. All rights reserved.
//

/*
 
 Owner: Stefan Neumärker <stefan@boinx.com>
 Company: Boinx Software Ltd., Germany
 Projects: BXQuartzComposer, PhotoPresenter3
 
 Abstract: bunch of methods handling infos from Info.plist and InfoPlist.strings
 
 Related: non
 
 Documentation : non
 
 */

#import <BXFoundation/BXConstants.h>

extern NSString *const kNSBundleNameKey;
extern NSString *const KNSBundleDisplayNameKey;
extern NSString *const kNSBundleExecutalbeKey;
extern NSString *const kNSBundleVersionKey;
extern NSString *const kNSShortVersionStringKey;
extern NSString *const kNSBundleIconFileKey;
extern NSString *const kNSBundleHelpBookNameKey;


@interface NSBundle (InfoPlist)
    
    
#pragma mark Whole Dicitionary
- (NSDictionary *)infoDict;
- (NSDictionary *)infoDictForBundleWithIdentifier:(NSString *)bundleIdentifier;
- (NSDictionary *)localizedInfoDict;
- (NSDictionary *)localizedInfoDictForBundleWithIdentifier:(NSString *)bundleIdentifier;
    
#pragma mark CFBundleName
- (NSString *)bundleName;
- (NSString *)bundleNameForBundleWithIdentifier:(NSString *)bundleIdentifier;
- (NSString *)localizedBundleName;
- (NSString *)localizedBundleNameForBundleWithIdentifier:(NSString *)bundleIdentifier;
    
#pragma mark CFBundleDisplayName
- (NSString *)bundleDisplayName;
- (NSString *)bundleDisplayNameForBundleWithIdentifier:(NSString *)bundleIdentifier;
- (NSString *)localizedBundleDisplayName;
- (NSString *)localizedBundleDisplayNameForBundleWithIdentifier:(NSString *)bundleIdentifier;
    
#pragma mark CFBundleExecutable
- (NSString *)bundleExecutable;
- (NSString *)bundleExecutableForBundleWithIdentifier:(NSString *)bundleIdentifier;
    
#pragma mark CFVersion
- (NSString *)bundleVersion;
- (NSString *)bundleVersionForBundleWithIdentifier:(NSString *)bundleIdentifier;
- (NSNumber *)bundleVersionAsNumber;
- (NSNumber *)bundleVersionAsNumberForBundleWithIdentifier:(NSString *)bundleIdentifier;
    
#pragma mark CFShortVersionString
- (NSString *)shortVersionString;
- (NSString *)shortVersionStringForBundleWithIdentifier:(NSString *)bundleIdentifier;
    
- (NSUInteger)majorVersion;
    
    //- (NSString *)localizedShortVersionString;
    //- (NSString *)localizedShortVersionStringForBundleWithIdentifier:(NSString *)bundleIdentifier;
    //- (NSNumber *)shortVersionStringAsNumber;
    //- (NSNumber *)shortVersionStringAsNumberForBundleWithIdentifier:(NSString *)bundleIdentifier;
    //- (NSNumber *)localizedShortVersionStringAsNumber;
    //- (NSNumber *)localizedShortVersionStringAsNumberForBundleWithIdentifier:(NSString *)bundleIdentifier;
    
#pragma mark CFBundleIconFile
- (NSString *)bundleIconFile;
- (NSString *)bundleIconFileForBundleWithIdentifier:(NSString *)bundleIdentifier;
    
#pragma mark CFBundleHelpBookName
- (NSString *)bundleHelpBookName;
- (NSString *)bundleHelpBookNameForBundleWithIdentifier:(NSString *)bundleIdentifier;
    
#pragma mark BXBuildStyle
- (NSString *)buildStyle;
- (NSString *)buildStyleForBundleWithIdentifier:(NSString *)bundleIdentifier;
    
#pragma mark versionString
- (NSString *)versionString;
    
#pragma mark fullProductName
- (NSString *)fullProductName;

    // Only for AppStore Versions - calculates the right values from other InfoDictionary keys
#pragma mark appStoreFullProductName
- (NSString *)appStoreFullProductName;
    
#pragma mark appStoreProductName
- (NSString *)appStoreProductName;
- (NSString *)appStoreProductNameForBundleWithIdentifier:(NSString *)bundleIdentifier;
    
#pragma mark appStoreLastBundleComponent
- (NSString *)appStoreLastBundleComponent;
- (NSString *)appStoreLastBundleComponentForBundleIdentifier:(NSString *)bundleIdentifier;

// Strings derived from info plist keys
- (NSString *)applicationSupportFolderName;
- (NSURL *)boinxConnectURL;

    
@end
