#import <Foundation/Foundation.h>


@interface NSString (BXFourCharCode)

/**
 * Converts a FourCharCode into a string.
 * Calls [self BX_stringWithFourCharCode:code allowNumber:YES];
 */
+ (instancetype)BX_stringWithFourCharCode:(FourCharCode)code;

/**
 * Converts a FourCharCode into a string.
 * @param allowNumber If code contains none ASCII characters the a string containing a number will be returned.
 * [NSString BX_StringWithFourCharCode:32 allowNumber:YES] == @"32";
 */
+ (instancetype)BX_stringWithFourCharCode:(FourCharCode)code allowNumber:(BOOL)allowNumber;

/**
 * Return the FourCharCode.
 * If any none convertable characters are found self.intValue is returned.
 */
- (FourCharCode)BX_fourCharCode;

@end
