//
//  NSURL+UIPResourceValue.h
//  Plus
//
//  Created by Maximilian Christ on 9/28/11.
//  Copyright (c) 2011 mczonk.de. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface NSURL (ResourceValue)

- (BOOL)boolValueForResource:(NSString *)resourceKey error:(NSError **)error;
- (BOOL)setBoolValue:(BOOL)value forResource:(NSString *)resourceKey error:(NSError **)error;

- (NSInteger)integerValueForResource:(NSString *)resourceKey error:(NSError **)error;
- (BOOL)setIntegerValue:(NSInteger)value forResource:(NSString *)resourceKey error:(NSError **)error;

- (float)floatValueForResource:(NSString *)resourceKey error:(NSError **)error;
- (BOOL)setFloatValue:(float)value forResource:(NSString *)resourceKey error:(NSError **)error;

- (id)objectValueForResource:(NSString *)resourceKey error:(NSError **)error;
- (BOOL)setObjectValue:(id)value forResource:(NSString *)resourceKey error:(NSError **)error;

- (NSNumber *)numberValueForResource:(NSString *)resourceKey error:(NSError **)error;
- (BOOL)setNumberValue:(NSNumber *)value forResource:(NSString *)resourceKey error:(NSError **)error;

- (NSString *)stringValueForResource:(NSString *)resourceKey error:(NSError **)error;
- (BOOL)setStringValue:(NSString *)value forResource:(NSString *)resourceKey error:(NSError **)error;

- (NSDate *)dateValueForResource:(NSString *)resourceKey error:(NSError **)error;
- (BOOL)setDateValue:(NSDate *)value forResource:(NSString *)resourceKey error:(NSError **)error;

@end
