//**********************************************************************************************************************
//
//  BXScreenChooserView.h
//
//  Author:		Peter Baumgartner, peter@baumgartner.com
//  Copyright:	©2005-2014 by IMAGINE GbR. All rights reserved.
//	Abstract:	View that displays all screens and lets you choose one
//
//**********************************************************************************************************************

#import <Cocoa/Cocoa.h>


@class BXScreenChooserView;


@protocol BXScreenChooserViewDelegate <NSObject>
@optional

- (void)BXScreenChooserView:(BXScreenChooserView *)screenChooserView didSelectScreen:(NSScreen *)screen;

@end


IB_DESIGNABLE @interface BXScreenChooserView : NSView
{
	NSUInteger _screenIndex;
	CGDirectDisplayID _screenID[64];
	NSRect _screenFrame[64];
	NSRect _menubarFrame;
	BOOL _enabled;
	
	NSGradient* _fillGradient;
	NSColor* _strokeColor;
	NSColor* _textColor;
	NSColor* _selectionColor;
	double _selectionWidth;
	
	id _observedObjectForScreenIndex;
	NSString *_observedKeyPathForScreenIndex;
	id _observedObjectForEnabled;
	NSString *_observedKeyPathForEnabled;
	NSMutableDictionary *_bindingsInfo;
}

@property (assign /*TODO weak*/) IBOutlet id<BXScreenChooserViewDelegate> delegate;

@property IBInspectable BOOL enabled;
@property NSUInteger screenIndex;
@property (retain) NSScreen *screen;

@property (retain) IBInspectable NSGradient* fillGradient;
@property (retain) IBInspectable NSColor* strokeColor;
@property (retain) IBInspectable NSColor* textColor;
@property (retain) IBInspectable NSColor* selectionColor;
@property IBInspectable double selectionWidth;

@end


//----------------------------------------------------------------------------------------------------------------------
