/*

 Owner: Michael Ehrmann, michael@boinx.com
 Company: Boinx Software Ltd., Germany
 Projects: BXFoundation, BXQuartzComposer, BXReadMeViewer
 
 Abstract: Globally defined macros
 
*/


//----------------------------------------------------------------------------------------------------------------------


#ifdef __OBJC__

#define BX_APPLICATION_SUPPORT_FOLDER_NAME @"Boinx"

#ifndef PREFS
#define PREFS [NSUserDefaults standardUserDefaults]
#endif

#ifndef DEFAULTS
#define DEFAULTS [NSUserDefaults standardUserDefaults]
#endif

#ifndef CLASS_BUNDLE
#define CLASS_BUNDLE [NSBundle bundleForClass:[self class]]
#endif

#ifndef MAIN_BUNDLE
#define MAIN_BUNDLE [NSBundle mainBundle]
#endif

#ifndef SYNTHESIZE
#define SYNTHESIZE(x) @synthesize x = _##x
#endif

#ifndef BXRelease
#define BXRelease(object) do { if (object) { id __old__ = object; object = nil; [__old__ release]; } } while (false)
#endif

#ifndef BXAutorelease
#define BXAutorelease(object) do { if (object) { id __old__ = object; object = nil; [__old__ autorelease]; } } while (false)
#endif

#endif


//----------------------------------------------------------------------------------------------------------------------


#ifndef BXClipValue
#define BXClipValue(x,a,b) do { if ((x)<(a)) (x)=(a); else if ((x)>(b)) (x)=(b); } while (false)
#endif

#ifndef BXCFRelease
#define BXCFRelease(object) do { if (object) { CFTypeRef old = object; object = NULL; CFRelease(old); } } while (false)
#endif

#ifndef BXFree
#define BXFree(block) do { if (block) { free(block); block=NULL; } } while (false)
#endif


//----------------------------------------------------------------------------------------------------------------------


// The following constant can be use to hide deprecation warning that we cannot eliminate, because there is
// no suitable replacements API available at the time. For code that suffers from this predicament, use the 
// following lines to suppress the warning...
// Note: With LLVM / clang this could be done on single line basis.
//
//    #if BX_SUPPRESS_DEPRECATION_WARNINGS_WITHOUT_SUITABLE_REPLACEMENTS
//    #pragma clang diagnostic push
//    #pragma clang diagnostic ignored "-Wdeprecated"
//    #endif
//
//    void SomeFunctionWithDeprecatedButStillRequiredStuffInside()
//    {
//        ...
//    }
//
//    #if BX_SUPPRESS_DEPRECATION_WARNINGS_WITHOUT_SUITABLE_REPLACEMENTS
//    #pragma clang diagnostic pop
//    #endif

#ifndef BX_SUPPRESS_DEPRECATION_WARNINGS_WITHOUT_SUITABLE_REPLACEMENTS
#define BX_SUPPRESS_DEPRECATION_WARNINGS_WITHOUT_SUITABLE_REPLACEMENTS 1
#endif


//----------------------------------------------------------------------------------------------------------------------
