//
//  NSString_Regex.h
//  BXFoundation
//
//  Created by Michael Ehrmann on 23.03.07.
//  Copyright 2007 Boinx Software. All rights reserved.
//
	
@interface NSString (CSRegex)

-(BOOL)matchedByPattern:(NSString *)pattern options:(NSInteger)options;
-(BOOL)matchedByPattern:(NSString *)pattern;

-(NSRange)rangeMatchedByPattern:(NSString *)pattern options:(NSInteger)options;
-(NSRange)rangeMatchedByPattern:(NSString *)pattern;

-(NSString *)substringMatchedByPattern:(NSString *)pattern options:(NSInteger)options;
-(NSString *)substringMatchedByPattern:(NSString *)pattern;

-(NSArray *)componentsSeparatedByPattern:(NSString *)pattern options:(NSInteger)options;
-(NSArray *)componentsSeparatedByPattern:(NSString *)pattern;

-(NSArray *)allSubstringsMatchedByPattern:(NSString *)pattern options:(NSInteger)options;
-(NSArray *)allSubstringsMatchedByPattern:(NSString *)pattern;

-(NSArray *)substringsCapturedByPattern:(NSString *)pattern options:(NSInteger)options;
-(NSArray *)substringsCapturedByPattern:(NSString *)pattern;

-(NSString *)escapedPattern;

@end
