/*!
 
 Owner: Florian Albrecht <florian@boinx.com>
 Company: Boinx Software Ltd., Germany
 
 Abstract: Provides a (container) view that draws a gradient in its background. Current implementation is based on NSGradient.
  
 */


@interface BXGradientView : NSView
{
	NSGradient *_gradient;
	CGFloat _angle;
	BOOL  _radial;
}

- (void) setGradientWithBeginningColor:(NSColor*)beginColor endingColor:(NSColor*)endColor;

@property (retain) NSColor *startingColor;
@property (retain) NSColor *endingColor;
@property (retain) NSGradient *gradient;
@property (assign) CGFloat angle;
@property (assign) BOOL radial;

@end
