//
//  IZMMainTabsMgr.h
//  PTUIBridge
//
//  Created by fistice on 2/28/25.
//

#import <PTUIBridge/ZMPTRouterCenter.h>
#import <PTUIBridge/ZMTabDefineHeader.h>
#import <PTUIBridge/ZMBannerItem.h>
#import <PTUIBridge/ZMHTabViewDelegate.h>
#import <PTUIBridge/ZMViewMgr.h>

@class ZMBannerItem;

@protocol IZMMainTabsMgr <ZMPTRoutableObject, ZMViewProviding,ZMHTabViewDelegate>

@property (nonatomic, readonly) ZMMainTabsType currentType;

@property (readonly, getter=isViewLoaded) BOOL viewLoaded;
@property (readonly, getter=isViewAppeared) BOOL viewAppeared;
@property (retain, nonatomic, nullable) IBOutlet NSView *headerView;

@property (readonly, nonatomic) NSArray <ZMTabItem *> *arrangedTabItems;

//tabItems
- (void)updateTabs;
- (void)forceUpdateUIImage;
- (nullable ZMTabItem *)tabItemForAssociatedMgr:(__kindof ZMTabItemMgr *)itemMgr;
- (BOOL)isTabDisplayed:(ZMTabItem *)tabItem;

//history
- (void)onSessionHistoryChanged;

//actions
- (void)onMenuSelectNextTab;
- (void)updateSidebarButtons;
- (void)selectTabAt:(NSUInteger)index;
- (BOOL)isSelectedMgr:(ZMTabItemMgr *)itemMgr;
- (void)updateStatusMessageActiveTimeBanner;
- (void)selectItemWithAssociatedMgr:(__kindof ZMTabItemMgr *)itemMgr;

//tips
- (NSView *)tipHostViewForMgr:(__kindof ZMTabItemMgr *)itemMgr;
- (nullable NSString *)getTabIdentifierFromType:(ZMMainTabsType)type;

//header view
- (void)layoutHeader;

//Popout
- (void)bringToFrontTabItem:(ZMTabItem *)tabItem;
- (void)mergeBackTabItem:(ZMTabItem *)tabItem;
- (void)popoutMail:(BOOL)isPop;
- (void)popoutCalendar:(BOOL)isPop;
- (BOOL)isTabCanPop:(ZMTabItem * )tabItem;
- (BOOL)isTabPopped:(ZMTabItem *)tabItem;
- (void)popOutTabItem:(ZMTabItem *)tabItem;

//move & drag
- (void)syncToWeb:(NSNumber *)reset;
- (void)saveCurrentTabItemsOrder;
- (void)sortTabItems:(NSMutableArray <ZMTabItem *> *)items;

//report
- (void)showReportWindow;
- (void)onHelpCenter:(id)sender;
- (void)onWorkvivoHelp:(id)sender;
- (void)onZoomCommunity:(id)sender;
- (void)onReport:(id)sender;

//profile
- (void)showDownloadMobileDialog;
- (void)closeDownloadMobileDialog;
- (void)showPersonalNoteView;

- (void)refreshTabToken:(NSDictionary *)param;
- (void)getTabToken:(NSDictionary *)param;

//Banner
- (void)responseVisibleStatus;

@end
