//
//  IZMMiniTabsMgr.h
//  PTUIBridge
//
//  Created by kay on 2/28/25.
//

#import <PTUIBridge/ZMPTRouterCenter.h>
#import <PTUIBridge/ZMTabDefineHeader.h>
#import <Prism/ZMBaseKit.h>
#import <PTUIBridge/ZMTabWidgets.h>
#import <PTUIBridge/ZMHTabView.h>

@class ZMBannerItem;

extern NSString *kZMUserDefaultSelectedTabType;
extern NSString *kZMUserDefaultSelectedTabIdentifier;

@protocol IZMMiniTabsMgr <ZMPTRoutableObject>

@property (nonatomic, readonly) ZMMainTabsType currentType;
@property (nonatomic, strong) NSMutableArray * _Nonnull currentNavList;

//UI Compoent
- (ZMTabWidgets *)currentWidget;
- (ZMHTabView *)currentTabView;

//Tabs Resource
- (NSMutableArray<ZMTabItem *> *)getItemsFromRegistedTabsAndselectedItem:(ZMTabItem **)selectedItem;
- (ZMTabItem *)getTabItemWithTabIdentifier:(NSString *)identifier;
- (void)setupTabItems;
- (ZMTabItem *)findFirstPinTabItemWithSkipSelected:(BOOL)skipSelected;

//Tabs Orders
- (void)getCurrentNavListFromUserProfile;
- (void)sortTabItems:(NSMutableArray <ZMTabItem *> *)items;
- (NSString *)getCustomizedNav;
- (NSArray <NSString *> *)defaultNavList;//default list from hard code 
- (nullable NSString * )getDefaultListStr;//default list from web
- (NSString *_Nonnull)getFullNavListFromOrder:(NSString *_Nonnull)orderStr;
- (nullable NSString * )getOrderListStr;
- (void)resetTabItemsOrderToDefault;
- (void)resetNavIconList;
- (void)syncToWeb:(NSNumber *)reset;

//Pin / Unpin
- (nullable NSArray *)getPinList:(BOOL)isPin;
- (BOOL)isFirstLoadNewTabs;
- (void)setPinCount:(NSInteger)pinCount;
- (void)setPinList:(BOOL)isPin listStr:(NSString *)listStr;
- (NSString *)getFullPinList:(BOOL)isPin hasPin:(BOOL)hasPin hasUnpin:(BOOL)hasUnpin lastPinStr:(NSString *)lastPinStr;
- (nullable NSArray *)getFullPinList:(BOOL)isPin;

//tab property
- (BOOL)isVisibleOfTab:(NSString *)TabID;

//Selected Tab Identifier Storage (supports both static and dynamic tabs)
- (nullable NSString *)getSelectedTabIdentifierForJid:(nullable NSString *)jid;
- (void)saveSelectedTabIdentifier:(nonnull NSString *)identifier forJid:(nullable NSString *)jid;

@optional
- (void)tabVisibleChanged:(ZMTabItem *_Nonnull)tabItem visible:(BOOL)visible;
- (void)selectTabItem:(ZMTabItem *_Nonnull)item updateCache:(BOOL)updateCache;


@end
