//
//  IZPCMDWindowManager.h
//  PTUIBridge
//
//  Created by fistice on 7/9/25.
//

#ifndef IZPCMDWindowManager_h
#define IZPCMDWindowManager_h

#import <PTUIBridge/ZMPTRouterCenter.h>
@class ZPCMDWindowModel;
@protocol ZPCMDWindowProtocol;
@protocol ZPCMDHuddleWindowProtocol;
@protocol IZPCMDWindowManager <ZMPTRoutableObject>
- (void)resetManager;
- (void)stopRinging;
- (void)acceptCallFromDevice;//ZOOM-4319
- (void)denyCallFromDevice;//ZOOM-4319
- (BOOL)existsCMDWindow;//ZOOM-10528
- (void)onMyHuddleStatusChanged;
- (void)incomeaVideoCall:(ZPCMDWindowModel*)model;
- (id<ZPCMDWindowProtocol>)getWindowControllerWithMeetingNumber:(NSNumber *)meetingNumber;
- (id<ZPCMDWindowProtocol>)getWindowControllerWithFriendId:(NSString *)friendId;
- (id<ZPCMDHuddleWindowProtocol>)getHuddleWindowControllerWithHuddleId:(NSString *)huddleId;

- (void)setHuddleRejoinReminder:(NSTimeInterval)fireTime model:(ZPCMDWindowModel*)model;
- (void)removeCmdItems:(id<ZPCMDWindowProtocol>)item;
- (void)removeHuddleCmdItems:(id<ZPCMDHuddleWindowProtocol>)item;
- (void)callHasBeenAnswered:(id<ZPCMDWindowProtocol>)currentController;
- (void)huddleCallHasBeenAnswered:(id<ZPCMDHuddleWindowProtocol>)currentController;
#ifdef __cplusplus
- (void)onDevicePresenceChanged:(const NS_ZOOM_MESSAGER::zDeviceInfo&)deviceInfo;
#endif
@end

#endif /* IZPCMDWindowManager_h */
