//
//  ZMPTUIHelper.h
//  PTUIBridge
//
//  Created by fistice on 2024/10/25.
//

#ifndef ZMPTUIHelper_h
#define ZMPTUIHelper_h

@protocol IZMPTUIHelper <NSObject>

- (void)initCurrentLocale;
- (void)setLanguageID:(NSString*)lanID;
- (NSString*)getZoomDisplayingVersionNumber;
- (NSString*)getZoomDisplayingVersionNumberWithTime;
- (NSString*)getOpenSourceURLByLangId;
- (void)showAboutView;
- (void)showCrashPanel;

- (BOOL)canJoinByIDNow;
- (void)setStartMeetingScenarioLocation;
- (BOOL)isMultiJoinSubProcess;
- (BOOL)isLaunchedByWebJoin;
- (BOOL)isInSpotMeeting;
- (void)activeHuddlesMeetingWindow;
- (BOOL)isInMeeting;
- (BOOL)canAccessZoomWebservice;
- (BOOL)isFeedbackOff;
- (BOOL)isGovUser;
- (BOOL)isDODUser;
- (void)onZoomCommunity;
- (BOOL)isNoMeetingLicenseUser;
- (BOOL)canAccessZoomWebService;
- (NSInteger)getAICFTStatus;
- (BOOL)getAICFTIsProUser;
- (BOOL)isZpnsAICSidePanelCanOpen;

- (NSString *)getLocalizedTermServiceURL;
- (NSString *)getLocalizedPolicyURL;

- (BOOL)uploadAvatar:(NSImage*)image;
- (void)notifyCanPromptFirstUpdate;

- (void)restartTheApplication;
- (BOOL)logout:(int)option;

- (BOOL)isGovDomain:(NSString *)domain;

- (BOOL)canZoomDisplayFontSize;
- (BOOL)isQualtricsFeedbackEnabled;
- (BOOL)isPTJoinByWeb;
- (BOOL)isCoBrandEnable;
- (NSImage * _Nullable)getLightCobrandingLogo;
- (NSImage * _Nullable)getDarkCobrandingLogo;
- (NSImage * _Nullable)getLightCobrandingDialogLogo;
- (NSImage * _Nullable)getDarkCobrandingDialogLogo;

- (NSString *)ZoomDomain;

- (BOOL)isQualtricsFeedbackEnabled;

- (BOOL)disableReportProblemGPO;

- (BOOL)setUserWorkLocation:(NSInteger)workLocation requestId:(NSString **)requestID;

- (int)getCallStatus;

- (void)registerDeeplinkServiceBySpecID:(NSString *)tabID;
- (void)unRegisterDeeplinkServiceBySpecID:(NSString *)tabID;
@end

#define ZMPTUIHelper ZMSharedFor(IZMPTUIHelper)

#endif /* ZMPTUIHelper_h */
