//
//  ZMToolPaletteController.h
//  ZMScreenCapture
//
//  Created by javenlee on 2018/2/13.
//  Copyright © 2018 ZOOM. All rights reserved.
//

#import <Cocoa/Cocoa.h>

typedef enum : NSUInteger {
    ZMAnnotationMode_Window,
    ZMAnnotationMode_View,
} ZMAnnotationMode;

@interface ZMToolPaletteView : NSView

@end

typedef NS_ENUM(NSInteger, ZMToolSelect){
    ZMPencilTool = 1001,
    ZMArrowTool,
    ZMRectangleTool,
    ZMCircleTool,
    ZMTextTool,
    ZMMosaicTool,
    ZMDownloadTool,
    ZMUndoTool,
    ZMRedoTool,
    ZMRecordTool,
    ZMCancelTool,
    ZMCutTool,
};

@protocol ZMToolPaletteDelegate <NSObject>
@optional
- (void)toolPaletteClicked:(ZMToolSelect)senderTag;
- (void)captureModeChange:(BOOL)recordMode;
@end

@class ZMCaptureButton, ZMBackgroundButton, ZMCancelButton, ZMSCDropButton;
@interface ZMToolPaletteController : NSViewController
@property (strong) ZMCaptureButton *pencilButton;
@property (strong) ZMCaptureButton *arrowButton;
@property (strong) ZMCaptureButton *recButton;
@property (strong) ZMCaptureButton *circleButton;
@property (strong) ZMCaptureButton *textButton;
@property (strong) ZMCaptureButton *mosaicButton;
@property (strong) ZMCaptureButton *downloadButton;
@property (strong) ZMCaptureButton *undoButton;
@property (strong) ZMCaptureButton *redoButton;
@property (strong) NSBox *line;
@property (strong) NSBox *line2;
@property (strong) ZMBackgroundButton *captureButton;
@property (strong) ZMCancelButton *cancelButton;

@property (assign) BOOL isRecordModeSelected; // NO: Capture mode, YES: Record mode

@property (nonatomic, strong) NSString *captureTitle;
@property (nonatomic,assign) id <ZMToolPaletteDelegate> delegate;
@property (nonatomic,assign) BOOL canUndo;
@property (nonatomic,assign) BOOL canRedo;
@property (nonatomic,assign) NSRectEdge popUpEdge;

@property (nonatomic, assign) ZMAnnotationMode annotationMode;

@property (nonatomic, assign) BOOL supportRecord;

- (void)cleanUp;

+ (id)sharedToolPaletteController;
- (void)updateCurrentGraphicClass:(ZMToolSelect)tool;
- (Class)currentGraphicClass;
- (void)popoverToTagButton:(NSInteger)tag;
- (void)closePopup;
- (void)reset;

- (void)updateRecordButtonWithRecordingState:(NSUInteger)recordingState;
- (void)updateRecordButtonWithRecordingState:(NSUInteger)recordingState duration:(NSTimeInterval)duration;
- (void)resetRecordButton;
- (void)setRecordingMode:(BOOL)isRecording;


@end
