//
//  IZMRingToneProtocols.h
//  ZoomSetting
//
//  Created by Lester Gong on 2025/10/11.
//

#ifndef IZMRingToneProtocols_h
#define IZMRingToneProtocols_h

NS_ASSUME_NONNULL_BEGIN

@protocol ZMSettingRingToneHelperEvent <NSObject>

@optional
- (void)onRingtoneDownloadDidFinished;
- (void)onRingtoneDownloadDidFailed;

@end

@protocol ZMSettingRingToneHelperAPI <ZMRoutableObject>

- (BOOL)isDownloading;

@end

@protocol IZMSettingRingToneHelper <ZMRoutableObject>

@optional

- (void)retryDownload;
- (void)checkUpdate;
- (void)updateRingToneResourcePath;

- (void)onRingtoneCheckUpdated:(NSString*)lastVersion downloadUrl:(NSString*)downloadUrl requestId:(NSString*)requestId result:(NSInteger)result;

@end



NS_ASSUME_NONNULL_END

#ifndef ZMSharedSettingRingToneHelper
#define ZMSharedSettingRingToneHelper ZMSharedFor(IZMSettingRingToneHelper)
#endif /* ZMSharedSettingRingToneHelper */

#endif /* IZMRingToneProtocols_h */
