//
//  IZMSettingPhoneHelper.h
//  ZoomSetting
//
//  Created by Lester Gong on 2025/10/11.
//

#ifndef IZMSettingPhoneHelper_h
#define IZMSettingPhoneHelper_h

NS_ASSUME_NONNULL_BEGIN

@class ZMSipCountry;

@protocol IZMSettingPhoneHelper <NSObject>

@optional

@property (nonatomic, strong) ZMSipCloudPBX *cloudPBX;
@property (nonatomic, strong) NSWindow *window;

- (void)onVBSettingWindowClose;
- (void)onUpdateCallOutRequestDone:(NSInteger)errCode updateId:(NSString *)updateId;
- (void)onCallOutInfoUpdate:(NSInteger)eventType callOutInfo:(ZMSipCallOutInfo *)callOutInfo;
- (void)onVerificationRequestDone:(NSInteger)errCode;
- (void)onResultForCountries:(NSArray<ZMSipCountry *> *)countries;
- (BOOL)onSipGreetingUpdated:(NSNotification *)notice;
- (void)onPhoneSettingViewDisappear;
- (void)showUserDownloadFailToast:(BOOL)isShow;

- (void)onMyAccountLinkClicked;
- (void)onCopyNumberClicked:(NSString *)number;
- (void)openLocationSystemSetting;
- (void)onCallDefaultChanged:(NSString *)bundleID;
- (void)onCallControlManageClicked;
- (void)onCommandLineOrURLTextFieldChanged:(NSString *)cmdString;
- (void)onLaunchBrowseBtnClick:(NSString *)cmdString;
- (void)onEditCallOutClicked:(NSString *)callInfoID;
- (void)onDeleteCallOutClicked:(NSString *)callInfoID;
- (void)onCallOutCheckButtonClickd:(BOOL)isChecked;
- (void)onRecordOrViewVideoGreeting;
- (void)onDeleteVideoGreeting;
- (void)onSendReportButtonClicked;
- (void)updateAutodialDefalutDeviceWithResult:(BOOL)success;
- (void)onDelegationSettingLinkClicked;
- (void)onDidLogout;
- (void)updateIntegrationInfo;
- (void)onTransLanguageChange:(NSString*)selectedName;
- (void)onTranslateLanguageChanged:(NSString*)selectedName;
- (void)updateTranscriptLanguageInfo;
- (void)updateTranslationLanguageInfo;

@end

NS_ASSUME_NONNULL_END

#ifndef ZMSharedSettingPhoneHelper
#define ZMSharedSettingPhoneHelper ZMSharedFor(IZMSettingPhoneHelper)
#endif /* ZMSharedSettingPhoneHelper */

#endif /* IZMSettingPhoneHelper_h */
