//
//  ZMRealisticAvatarHelper.h
//  ZoomSetting
//
//  Created by vinson.wang on 2025/11/14.
//

#import <Cocoa/Cocoa.h>

NS_ASSUME_NONNULL_BEGIN

/**
 * ZMRealisticAvatarHelper
 * Encapsulates the PhotorealisticAvatar related interfaces provided by the common layer
 */
@interface ZMRealisticAvatarHelper : NSObject

+ (instancetype)shared;

/**
 * Get PhotorealisticAvatar data manager
 * @return PhotorealisticAvatar data manager
 */
#ifdef __cplusplus
- (ICmmVideoPhotorealisticAvatarDataMgr*)getPhotorealisticAvatarDataMgr;
#endif

/**
 * Check if web setting is enabled
 * @return Whether PhotorealisticAvatar setting is enabled
 */
- (BOOL)isPhotorealisticAvatarEnabled;

/**
 * Check if device supports PhotorealisticAvatar
 * @return Whether PhotorealisticAvatar is supported
 */
 - (BOOL)canDeviceSupportPhotorealisticAvatar;

/**
 * Get Avatar count
 * @return Total number of Avatars
 */
- (NSInteger)getAvatarsCount;

/**
 * Enable/disable Avatar creation mode
 * @param enable Whether to enable creation mode
 */
- (void)enablePhotoAvatarCreateMode:(BOOL)enable;

/**
 * Check if it is a virtual camera
 * @param deviceID Device ID
 * @return Whether it is a third-party virtual camera
 */
- (BOOL)isThirdPartyVirtualCamera:(NSString*)deviceID;

/**
 * Check if using third-party virtual camera
 * @return Whether using a third-party virtual camera
 */
- (BOOL)isUsingThirdPartyVirtualCamera;

@end

NS_ASSUME_NONNULL_END

