//
//  ZMSIPPTUIProtocol.h
//  SaasBeePTUIModule
//
//  Created by Mark Yang on 2021/4/27.
//  Copyright © 2021 Zoom. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <Prism/Prism.h>
#import <ZoomUnit/ZMSipLanguageListProtocol.h>

NS_ASSUME_NONNULL_BEGIN

@class ZMSipFeatureOption;
@class ZMBuddyAdapter;
@class ZMBuddyGroupAdapter;
@class ZMEncryptDevice;
@class ZMSipCallOutInfo;
@class ZMSipVerificationCodeParam;
@class ZMSipCallOutInputParam;
@class ZMSipCountry;
@class ZMSipRingOutInfo;
@class ZMAssignedGroupParam;
@class PZMMenuItem;
@class ZMToastCoordinator;
@class ZMSipLanguageList;

@protocol ZMSIPCallHelperProtocol <NSObject>

//upgrade
- (BOOL)UpgradePhoneTabShowTypeNone;

- (void)onPhoneCallConnected;
- (void)onPhoneCallHoldState:(BOOL)onHold;
- (void)endAllCalls;

- (BOOL)IMEnable;
- (BOOL)isVideoMirrorEnabled;
- (BOOL)isSendingAnySharing;

- (void)enterPhoneTab;
- (void)leavePhoneTab;

// sip service
- (void)onRefreshCloudPBXInfo;
- (void)onRegister:(BOOL)result respCode:(NSInteger)respCode;
- (void)onSipUserStatusChange:(NSInteger)status;
- (void)updateDiagnosticCallSessionSummary;
- (void)onUpdateDiagnosticCallSessionSummary:(NSArray <NSString *> *)callIDs commonData:(NSDictionary *)commonDic;
- (void)onSipCallServiceStarted;
- (void)onSipCallStatusUpdated;
- (void)callStatusUpdated:(int)status;
//remove phone privilege, add phone privilege again;
- (void)onReAssignedPhonePrivilege;

- (void)onPSILikeReboot;
- (void)asyncReleasePSIDidFinish;

- (void)onSipFeatureOptionsChanged:(NSArray <ZMSipFeatureOption *> *)changes;
- (void)onRequestDoneForUpdateSipFeatureOptions:(BOOL)isSuccess options:(NSArray <ZMSipFeatureOption *> *)options;

// audio session
- (void)onAudioDeviceUpdated;
- (void)startRing;
- (void)denyCallFromMeeting;
- (void)cleanUpAudioDevice;
- (void)try2SyncMuteStatus2zzHostDevice:(BOOL)isMuted;
- (void)try2SyncMuteStatus2zzHostDevice;
- (NSInteger)requestAccessMicrophone;
- (NSInteger)requestAccessCamera;
- (BOOL)IsSupportPlaySoundWhenReceiveMsg;
- (NSArray*)getAudioDeviceMenuItems;
- (NSArray*)getAudioDevicePrismMenuItems;
- (void)updateDefaultMicName:(NSString*)deviceId isBluetooth:(BOOL)bluetooth;

- (BOOL)isCallMuted;

//meeting
- (void)startMeetingWithFriendJid:(NSString *)jid;

//call history
- (void)clearAllMissedCallCount;
- (void)updateMissedCallCount:(NSInteger)count;

//voicemail
- (void)onVMHasNewMsg:(BOOL)hasNew newCount:(NSInteger)count;
- (void)onVoicemailPriorityTopicsChanged;
- (void)onVoicemailConciseCardViewPlayButtonClicked;
- (void)onVoicemailConciseCardViewViewMoreButtonClicked;

// transcript language
- (BOOL)isTranscriptDefaultLanguageSettingAvailable;
- (nullable NSString *)defaultTranscriptLanguage;
- (nullable id<ZMSipLanguageListProtocol>)transcriptLanguageList;
- (void)requestForUpdateDefaultTranscriptLanguage:(NSString *)language;
- (void)onDefaultTranscriptLanguageUpdated;

// translation language
- (BOOL)isPreferredTranslationLanguageSettingAvailable;
- (nullable NSString *)preferredTranslationLanguage;
- (nullable id<ZMSipLanguageListProtocol>)translationLanguageList;
- (void)setPreferredTranslationLanguage:(NSString *)language;
- (void)onPreferredTranslationLanguageUpdated;

//videomail
- (NSWindowController *)getSharedSipVBWindowCtrl;
- (void)onDeleteVideoGreeting;

// encrypt
- (void)showAllDevices;
- (void)showCanDecryptDevices:(NSString *)reqId;
- (void)onCanDecryptDevicesResult:(NSArray *)devices requestId:(NSString *)reqId;
- (ZMEncryptDevice *)getEncryptDevice;

//E911
- (void)onLocationAccessStatusChanged;

//emoji
- (void)showEmojiWithPositionView:(NSView *)positionView delayShow:(BOOL)delayShow emojiType:(NSInteger)emojiType delegate:(id)delegate;
- (void)startSMSSearchWithSessionId:(NSString*)sessionId currentSMSSessionId:(NSString*)currentSessionId;

//vCard
- (NSView *)getUserProfileView:(NSString *)jid;
- (void)showUserProfilePannelByJid:(NSString *)jid onWindow:(NSWindow *)window;

//chat
- (void)startChat:(NSString *)JID;
- (void)startChannelChat:(NSString*)channelId;
- (BOOL)chatDisable;
- (BOOL)isChatOneOneDMDisabled;

//user info

- (ZMBuddyAdapter *)getCallUserInfo:(NSString *)number isSearchCloudContact:(BOOL)isSearch ignoreMyself:(BOOL)ignoreMyself;
- (ZMBuddyAdapter*)getMyUserInfo;
- (NSString*)getUserNameByID:(NSString*)jID;
- (NSImage*)getUserAvatarByID:(NSString*)jID;
- (NSImage *)getUserAvatarByID:(NSString *)jID avatarSize:(CGSize)avatarSize;
- (NSImage *)getUserAvatarByName:(NSString *)userName andJID:(NSString *)JID;

- (BOOL)isChatDisableByJid:(NSString *)jid;
- (BOOL)isMeetDisableByJid:(NSString *)jid;
- (void)searchUserByNumber:(NSString*)number;

- (BOOL)existsSettingsItemValueForKey:(NSString*)key;

//Contact
- (BOOL)isConnectContactsPromptReaded;
- (BOOL)setConnectContactsPromptAsReaded:(BOOL)isRead;
- (void)jumpToWebToAuthCloudContactPermission;
- (BOOL)checkIsHaveConnectContactPermisson;
- (void)setAuthPermissionFromHistory:(BOOL)isNeedPopAlert;
- (void)showAddContactPanel;
- (BOOL)isCloudContact:(NSString *)jid;
- (NSWindow *)popCloudContactWindowWithNumber:(NSString*)number actionType:(NSInteger)actionType contactType:(NSInteger)contactType;
- (NSWindow *)popCloudContactWindowWithNumber:(NSString *)number actionType:(NSInteger)actionType isSupportPersonal:(BOOL)isSupportPersonal isSupportCloud:(BOOL)isSupportCloud tagId:(NSString *)tagId;
- (void)closeCloudContactWindowWithIsConfirm:(BOOL)isConfirm;
- (NSMutableArray<ZMHMenuItem*> *)vipGroupMenuWithJid:(NSString *)jid;
- (ZMHMenuItem *)removeVipMenuWithJid:(NSString *)jid groupId:(NSString *)groupId;
- (NSMutableArray<ZMHMenuItem*> *)vipGroupMenuWithNumber:(NSString *)number;

- (NSArray<PZMMenuItem *> *)vipGroupPrismMenuWithJid:(NSString *)jid menuIcon:(nullable NSImage *)image;
- (NSArray<PZMMenuItem *> *)vipGroupPrismMenuWithNumber:(NSString *)number menuIcon:(nullable NSImage *)image;

- (BOOL)requestUCSGroupId:(NSArray<NSNumber *> *)groupTypes;  //BuddyGroupType

- (void)subscribeContactsPresence:(NSArray *)jids needLocalSearch:(BOOL)needLocalSearch;
- (void)refreshContactVcard:(NSArray *)jids;
- (BOOL)addBuddyToLocal:(ZMBuddyAdapter *)buddyAdapter;

- (NSString *)findNameByPhoneNumber:(NSString *)number;
- (nullable ZMBuddyAdapter *)findCloudContactWithPhone:(NSString *)phoneNumber;

- (int)getNumberType:(NSString *)number;
- (BOOL)matchIsExtensionWithNumber:(NSString *)number; //ZOOM-117458
- (NSString *)getCloudPhoneNumberTypeWithType:(NSInteger)type;
- (BOOL)isEnableZRATab;
- (BOOL)isEnabledDocsTab;

//UI
- (NSWindow *)getMainWindow;
- (ZMToastCoordinator *)getMainToastCoordinator;
- (ZMToastCoordinator *)getFaxMainToastCoordinator;

- (BOOL)isCurrentWindowCompressed;
- (BOOL)mainWindowIsVisible;
- (void)callMainWindowBack;
- (void)toggleCompressWindow;

- (void)showSettingWindowAndSeletectdAudioTab;
- (void)showSettingWindowAndSelectedPhoneTab;
- (void)showPhoneSettingWindowAndScrollToTranslation;
- (void)updateIntegrationWithErrorCode:(NSInteger)errorCode msg:(NSString *)errorMsg;

- (void)jumpToContactTab;
- (void)jumpToDocsTab;
- (void)jumpToPhoneTab;
- (void)jumpTofaxTab;
- (BOOL)isInFaxTab;
- (void)jumpToSMSTab;
- (void)navigate2SipTab;
- (BOOL)isCurrentInPhoneTab;
- (BOOL)isCurrentInSMSTab;
- (BOOL)isSMSTabInNavBar;
- (void)jumpToPhoneHistoryTabIfInSMS;

- (void)onSipCallIsEstablished;
- (void)onIncomingCallDeclied;
- (void)onSipCallingViewMinimized:(BOOL)minimize;

- (void)onUnreadVoiceMailChanged:(NSInteger)count;
- (void)onMissedCallHistoryChanged:(NSInteger)count;
- (void)notifyUnloadSipServerNotReadCountChange:(NSInteger)unreadCount;

//3rd party auto dial
- (void)updateAutodialDefalutDeviceWithResult:(BOOL)success;

// Receive Call config
- (void)onReceiveCallSettingUpdated:(BOOL)success;
- (void)onFeatureOptionChanged:(NSInteger)featureBit featureStatus:(BOOL)bOpen;

//Custom ringtone
- (float)getRingtoneVolume;
- (float)getCallWaitingVolume;
- (NSString*)getRingtonePath:(NSString*)number userJid:(NSString*)jid;

//DND setting
- (NSString*)getDoNotDisturbTime;
- (BOOL)isInDNDOrSnoozeRange;
- (NSString*)getDNDRemainedDuration;
- (void)changeDNDTime:(NSInteger)tag;
- (void)turnOffDND;
- (void)settingAutoDNDTime;

//Power User
- (BOOL)isShowPowerUserPhone;
- (void)onPowerUserEnableOptionChanged;
- (BOOL)isWebEnableHideZoomPhoneAssistantOnIdle;

//Contacts Search
- (void)resignSearchFieldFirstResponder;

//Location
- (void)needShowLocationTipsInTab:(BOOL)isShow;

// ZOOM-217028
- (void)refreshEmergencyAddreeInSetting;
- (void)emergencyAddressCallBack:(NSString *)defaultAddress;

- (void)countryCodeChanged;

- (NSString*)getCurrentVersion;

- (nullable ZMBuddyAdapter *)getBuddyByJID:(NSString *)JID;
- (nullable ZMBuddyAdapter *)getCloudBuddyByID:(NSString *)ID;

//IP Phone
- (void)updateIPPhoneDevices;
- (void)onDeviceInfoChanged:(NSString *)toastStr;
- (NSString *)getManagerOnWebLink;
- (void)onIPPhoneConnectResult:(BOOL)success isDissconnect:(BOOL)isDissconnect needReset:(BOOL)needReset deviceName:(NSString *)deviceName;
- (BOOL)isRemoteControlEnable;
- (BOOL)isInIPPhoneCall;
- (NSString *)getCallControlSupportLink;
- (BOOL)isUserBlocked:(NSString*)jid;

//ZOOM-312669
-(NSMutableArray<ZMBuddyAdapter *> *)getAllStarBuddies;
- (BOOL)isStarredSession:(NSString *)sessionId;
- (BOOL)starSession:(NSString *)sessionId starred:(BOOL)starred;
- (NSString *)getCurrentLang;

- (NSString *)syncUcsBuddyGroupMember:(ZMAssignedGroupParam *)groupParam;
- (NSArray<NSString *> *)getAssignedGroups;
- (ZMBuddyGroupAdapter*)getAssignedGroupByID:(NSString *)groupID;

//Speed Dial
- (NSString*)requestSpeedDialContacts;
- (NSString*)requestRecentTransferContacts;
- (NSString*)syncSpeedDialContacts:(NSArray<NSDictionary*>*)contacts;
- (NSString*)syncRecentTransferContacts:(NSArray<NSDictionary*>*)contacts;

//AAD Profile
- (NSString*)requestAADContactProfile:(NSString *)jid;

- (void)onRefreshVCardDone:(NSString *)jid;

//Call Forwarding
- (void)onSipCallForwardingStatusChange;

//Call Out
- (void)onCallOutInfoUpdate:(NSInteger)eventType callOutInfo:(ZMSipCallOutInfo *)callOutInfo;
- (void)onDeleteCallOutRequestDone:(BOOL)success deleteId:(NSString *)deleteId;
- (void)onUpdateCallOutRequestDone:(NSInteger)errCode updateId:(NSString *)updateId;
- (void)onVerificationRequestDone:(NSInteger)errCode;
- (void)onResultForCountries:(NSArray<ZMSipCountry *> *)countries;
- (void)onRingOutUpdate;

//SMS Delegation
- (void)onSMSDelegationStatusChanged;

//SBA
- (void)notifySBANetworkStatus:(BOOL)bConnect;

//Restrict
- (BOOL)isAllowCallForMac;
- (BOOL)isRestrictSMSForMac;;
- (BOOL)isAllowSMSCopyForMac;
- (BOOL)showBlockSMSCopyAlertIfNeeded;
- (void)onRestrictFeatureUpdated;
- (BOOL)isSMSTabVisible;
- (void)onSMSTabOptionsChanged;

//SMS
- (NSMutableArray *)getMessageContext:(NSString *)sessionId messageId:(NSString *)messageId;

- (void)didSMSFileCanceledWithFileId:(NSString *_Nonnull)fileID sessionId:(NSString * _Nonnull)sessionId messageId:(NSString * _Nonnull)messageId;

- (void)didSMSFileDownloadedWithFileId:(NSString *_Nonnull)fileID sessionId:(NSString * _Nonnull)sessionId messageId:(NSString * _Nonnull)messageId;

- (void)didSMSFileInProgressWithFileId:(NSString *_Nonnull)fileID sessionId:(NSString * _Nonnull)sessionId messageId:(NSString * _Nonnull)messageId ratio:(NSInteger)ratio completeSize:(NSInteger)completeSize bitPerSecond:(NSInteger)bitPerSecond;

//Send chat text
- (NSString*)sendChatText:(NSString*)text userId:(NSString*)userId;

//India
- (void)notifyIndiaKYCStatus:(NSString *)error data:(NSString *)data;

//fax
- (void)showFaxTabWithCount:(NSInteger)count;
- (void)hiddenFaxTab;
- (void)faxOptionsChanged:(BOOL)isEnable;
- (void)faxUnreadCountChanged:(int)count;
- (void)clearFaxUnreadCountInPhoneTab;
- (BOOL)isFaxTabVisible;
- (void)showFaxFilePickerWindow:(NSInteger)type fileType:(NSString *)fileType;
- (void)closeFaxFilePickerWindow;

//switch call
- (void)onSwitchCallUpdate:(NSUInteger)switchCallCount;

- (BOOL)isAutoTrackBillingHourFeatureEnable;
- (BOOL)isTrackBillingHourFeatureEnable;

//AI Companion
- (BOOL)isAICompanionEnabled;
- (void)showAICompanionPanel;
- (NSWindow *)showAICompanionPanelWithPopoutFrame:(NSRect)frame;
- (void)closeAICompanionPanel;
- (BOOL)isShowAICompanionPanel;
- (NSWindow *)getAICompanionPanelWindow;
- (NSWindow *)getAICompanionPanelPopoutToPowerUserWindow;

// MS Teams DeepLink Url
- (BOOL)requestMSTeamsDeepLinkUrl:(NSString *)from;
- (BOOL)isMSTeamsDeepLinkHistoryUrlRequested;
- (BOOL)isMSTeamsDeepLinkVoicemailUrlRequested;
- (NSString *)getMSTeamsDeepLinkHistoryUrl;
- (NSString *)getMSTeamsDeepLinkVoicemailUrl;
- (void)cleanUpMSTeamsDeepLinkUrl;

// Auto Answer
- (void)onCallQueueAutoAnswerPeriodListUpdated:(NSUInteger)index;
- (void)onCallQueueSettingUpdated;

//billing
- (NSString *)getContactClientCodeWithJid:(nullable NSString *)jid contactType:(int)contactType;

@end

NS_ASSUME_NONNULL_END
