//
//  ZMSettingPhoneViewController.h
//  ZoomSetting
//
//  Created by Lester Gong on 2024/12/26.
//  Copyright © 2024 Zoom. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <ZoomSetting/ZMSettingItemViewController.h>

@class ZMSipCallOutInfo, ZMSettingMgr;
@protocol ZMSettingPhoneProtocol;
@protocol IZMSettingPhoneHelper;
@protocol ZMSettingPhoneProtocol;

NS_ASSUME_NONNULL_BEGIN

@interface ZMSettingPhoneViewController : ZMSettingItemViewController <ZMSettingPhoneProtocol>

- (instancetype)initWithSettingMgr:(ZMSettingMgr *)settingMgr;

@property (nonatomic, strong, readonly) id<IZMSettingPhoneHelper> phoneHelper;

+ (instancetype)createPhoneViewControllerWithSettingMgr:(ZMSettingMgr *)settingMgr;

- (void)didLogout;
- (void)showVoicemailTopicsManage;

- (void)configPhoneDataModel;

- (void)setupUI;

- (void)handleSubclassEvent:(void *)event;

- (BOOL)isCloudPBXController;

@end

NS_ASSUME_NONNULL_END
