//
//  ZMIMScreenShotMgr.h
//  SaasBeePTUIModule
//
//  Created by john on 04/12/2017.
//  Copyright © 2017 Zoom. All rights reserved.
//

#import <Foundation/Foundation.h>

#define zoomIdentifier @"us.zoom.xos"

@protocol ZMScreenshotConnectionProtocol <NSObject>

- (void)captureDidSucceed:(NSData *)imageData;
- (void)captureFailed;
- (void)captureDidDownload:(NSData *)imageData;
@optional
- (void)recordDidSucceed:(NSString *)filePath;
- (void)recordFailed:(NSError *)error;

@end

@interface ZMIMScreenShotMgr : NSObject <ZMScreenshotConnectionProtocol>
{
    NSString*           _identifier;
    
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdeprecated-declarations"
    NSConnection*       _connection;
#pragma clang diagnostic pop
    
    NSString *          _uuid;
}

/// Indicates whether a screenshot is currently being captured
@property (nonatomic, assign, readonly) BOOL capturingImage;

/// Indicates whether a video recording is currently in progress
@property (nonatomic, assign, readonly) BOOL capturingVideo;

+ (ZMIMScreenShotMgr *)screenshotMgr;

- (void)cleanUp;

- (void)screenshotWithSystemApp;
- (void)screenshotRecordWithSystemApp;

/// current switch status
- (BOOL)hideChatWindow;

/// the following APIs (startCaptureFromHotkey, startCapture, startCaptureWithCallback:)
/// will make screenshot and check if need hidden zoom chat window from native setting `[[NSUserDefaults standardUserDefaults] boolForKey:kCaptureWithoutChatWindow]`
- (BOOL)startCaptureFromHotkey;
- (BOOL)startCaptureRecord;
- (BOOL)startCapture;
- (BOOL)startCaptureWithCallback:(id <ZMScreenshotCallback>)callback;

/// this will make screenshot and check if need hidden zoom chat window with specific flag: hideChatWindow
- (BOOL)startCaptureWithCallback:(id <ZMScreenshotCallback>)callback hideChatWindow:(BOOL)hideChatWindow;

- (void)addDefaultCallback:(id <ZMScreenshotCallback>)callback;

- (void)removeCallback:(id <ZMScreenshotCallback>)callback;


@end
