//
//  ZMMessageListViewController.h
//  zChatComponent
//
//  Created by groot Ding on 4/30/25.
//

#import <zChatComponent/ZMChatMessageDataSource.h>
#import <zChatComponent/ZMMessageCellViewDelegate.h>
#import <zChatComponent/ZMMessageInputProtocol.h>
#import <zChatComponent/ZMChatAppViewController.h>
#import <zChatComponent/ZMIMCommonDefine.h>
#import <zChatComponent/ZMMessageMenuImpl.h>
#import <Prism/ZMIMTrackingScrollView.h>

NS_ASSUME_NONNULL_BEGIN

@class ZMFilePickerChatApp;
@class ZMChatMsgItemInfo;
@class ZMChatFileItem;
@class ZMIMMessageLayoutConfig;
@class ZMBaseMessageCellView;
@class ZMToastCoordinator;
@class ZMIMMessageLayoutConfig;
@class ZMChatAppShortcutInfo;
@class ZMInputTextView;
@class ZMChatsInputContainerViewCtrl;
@class ZMAddReplyMessageCellView;
@class ZMToast;
@class ZMIMListView;
@class ZMMessageMenuImpl;

@interface ZMStashTableViewVisableInfo : NSObject

@property (nonatomic,retain) id targetNode;
@property (nonatomic,assign) NSPoint offset;

@property (nonatomic,assign) BOOL isBottomWhenStash;
@property (nonatomic,readonly) BOOL isEditingWhenStash;

@end

#ifndef __ZOOM_NO_CLIENT_LOG

@interface ZMMessageListClipView : ZMLoadingClipview

- (NSArray *)scrollRecordingCallStacks;

- (void)cleanScrollRecordingCallStacks;

@end

#endif

@interface ZMMessageListViewController : ZMBaseViewController <ZMChatMessageDataSource,
ZMChatMessageLoadDelegate,ZMListViewDataSource,ZMListViewDelegate,ZMMessageCellViewDelegate,ZMChatAppDelegate>

@property (nonatomic,strong) ZMIMListView *messagesOutlineView;

@property (nonatomic,copy) NSString* sessionID;

@property (nonatomic,strong) ZMChatMessageDataSourceImpl *mainDataSourceImpl;

@property (nonatomic,readonly) NSString *sessionName;

@property (nonatomic,readonly) NSString *sessionNameWithoutGroup;

@property (nonatomic,copy) NSString *loadingReplyThread;

@property (nonatomic,readonly) BOOL isVirtualSession;

@property (nonatomic,readonly) BOOL isMySelfSession;

@property (nonatomic,readonly) BOOL isMeetingSession;

@property (nonatomic,readonly) BOOL isPrivateSession;

@property (nonatomic,readonly) BOOL isRobot;

@property (nonatomic,readonly) BOOL isE2EEnabled;

@property (nonatomic,readonly) BOOL needLoadMoreRecent;

@property (nonatomic,assign) BOOL isManualScroll;

@property (nonatomic,assign) BOOL isSyncDoneWhenInit;

@property (nonatomic,assign) BOOL automaticLoadMessageWhenOnline;

@property (nonatomic,assign) BOOL isNeedShowLoadFail;

@property (nonatomic,assign) BOOL isNeedShowAvatarPresence;

@property (nonatomic, assign) BOOL shouldAutomaticChangeFontSize;

@property (nonatomic, assign) BOOL shouldSelectedMoreButtonClick;

@property (nonatomic,strong,nullable) ZMIMMessageLayoutConfig *layoutConfig;

@property (nonatomic,copy) NSArray<ZMChatAppShortcutInfo *> *threadShortcuts;

// layoutManagerClass, works when tableView reloads, nullable (ZOOM-401850)
@property (nonatomic,assign) Class layoutManagerClass;

@property (nonatomic,strong) id<ZMToastCoordinatorProtocol> toastCoordinator;

@property (nonatomic,strong) ZMStashTableViewVisableInfo *stashVisableInfo;

@property (nonatomic,strong) ZMFilePickerChatApp *filePickerChatApp;

@property (nonatomic, weak) ZMChatAppViewController *chatAppViewCtrl;

@property (nonatomic,readonly) NSDate *lastCloseDate;

- (instancetype)initWithSessionID:(NSString*)sessionID;

- (void)setupDataSource;
- (void)setupSubViews;
- (void)setupMessageOutlineView;

- (void)onMouseMoveEvt:(NSEvent*)inEvent;

- (ZMChatMessageDataSourceImpl *)dataSourceImpl;
- (ZMChatMessageDataSourceImpl *)getDataSourceBySessoinId:(NSString *)sessionId;

- (ZMChatsInputContainerViewCtrl * _Nullable)inputViewCtrl;
- (ZMChatsInputContainerViewCtrl * _Nullable)inputViewCtrlForNewChats;

- (ZMMessageMenuImpl *)initializeMessageMenu;

- (Class)fetchCellLayoutManager;

- (void)registerNotification;

- (void)resetCellHeight:(BOOL)fontSizeChanged;

- (void)updateUIForFontSizeRate:(NSInteger)sizeOffset;

- (BOOL)checkNeedUpdateBuddies:(NSArray<NSString *> *)jids;

- (void)updateVisableBuddies;

- (void)updateVisableBuddies:(NSArray<NSString *>*)jids;

- (void)updateNames;

- (void)resetVisibleCell;

- (NSInteger)findStableRowForStashingScroll;

- (void)scrolledToTheEnd:(NSScrollView *)scrollView;

- (ZMInputTextView *)mainInputTextView;

- (void)checkBlockStatus;
- (void)updateWhenBlockStatusChanged:(BOOL)isBlocked;

- (void)updateReadReceiptsMessageWithForceUpdate:(BOOL)forceUpdate __attribute__((objc_direct));

- (BOOL)updateMessageWithID:(NSString*)msgID;

- (void)scheduleDecodeVisableUndecodedMessages;

- (void)onResendItem:(ZMChatMsgItemInfo*)item forCellView:(ZMBaseMessageCellView*)cellView;

- (BOOL)shouldJump2Message:(NSTreeNode *)msgNode;

- (void)addInputMessageReply:(NSTreeNode *)msgNode;
- (ZMAddReplyMessageCellView*)getReplyMessageCellViewForThreadID:(NSString*)threadID createIfNeed:(BOOL)createIfNeed;
- (ZMAddReplyMessageCellView *)getExitedReplyCellViewForThreadId:(NSString*)threadId;

- (void)addTimeChatIfNeed;
- (void)updateTimedChatMessage;

- (void)loadMorePullDownMessages;
- (void)loadMorePullUpMessages;
- (void)loadMoreCommentMessageByIds:(NSDictionary *)threadIds;
- (void)updateCanLoadMorePullDownMessage;
- (void)updateCanLoadMorePullUpMessage;
- (void)updateLoadMorePullDownFinish;
- (void)updateLoadMorePullUpFinish;
- (void)reloadMoreMessageWithThreadCount:(NSInteger)threadCount;

- (void)updateOnScreenBotMessages;

- (void)onSyncDone;

- (void)updateFromMessageCellViewWithNode:(NSTreeNode *)item;
- (void)updateMessageUIByNode:(NSTreeNode *)msgNode;
- (void)noteHeightOfRowsWithIndexesChangedWithoutAnimation:(NSIndexSet*)indexSet;

- (void)tryStashCurrentVisibleScroll;
- (void)tryRecoverCurrentVisibleScroll;

- (void)stashCurrentVisableScroll;
- (void)recoverLastVisableScroll;

- (ZMStashTableViewVisableInfo *)stashCurrentVisableListView;
- (BOOL)recoverVisableListView:(ZMStashTableViewVisableInfo *)info;

- (void)resetLastVisableScroll;

- (BOOL)scrollToEditMyFirstThread;
- (BOOL)scrollToEditMyPreviewCommentUnderThread:(NSString*)threadID;

- (BOOL)legalToEditMessageByMsgId:(NSString *)msgId;
- (void)beginEditMessageByNode:(NSTreeNode *)node;
- (void)onCodeSnippetEdit:(NSString*)inMsgId;
- (BOOL)isPullDownToLoadMore;

- (NSView *)messageCellViewOfMessageWithID:(NSString *)msgID;

#pragma mark - Chat App

- (void)closeChatApp;
- (void)openChatApp:(ZMChatAppContext *)context referenceView:(NSView * _Nullable)view;

#pragma mark - tipview
- (void)showTipView:(ZMTipView_Type)type;
- (void)showTipView:(ZMTipView_Type)type withData:(NSDictionary* _Nullable)extraData;
- (void)showBroadcastAnnouncementPlaceholderView:(ZMTipView_Type)type;
- (void)closeTipView;

- (void)onMessageCountChanged;
- (void)onMessageCountChanged:(NSError *)error;
- (void)onMessageCountChanged:(NSError *)error isFromServer:(BOOL)isFromServer isSyncHistory:(BOOL)isSyncHistory;

- (void)showToast:(ZMToast*)toast;
- (void)removeToast:(ZMToast*)toast;

- (void)openImagePreviewByItem:(ZMChatMsgItemInfo *)item fileItem:(ZMChatFileItem *)fileItem;

#pragma mark - loading & failed

- (void)showLoadingFailedUI;
- (void)hideLoadingFaileddUI;
- (BOOL)isShowLoadingIndicator;
- (BOOL)isShowLoadFailed;
- (void)startLoadingIndicator;
- (void)stopLoadingIndicator;

- (void)menuItemClick:(ZMHMenuItem *)item;

- (NSArray <ZMHMenuItem *> *)customSubMenuItem:(ZMIMTextViewMenuTag)menuTag msgItem:(ZMChatMsgItemInfo *)msgItem inView:(NSView *)inView;

@end

NS_ASSUME_NONNULL_END
