#ifndef _CONF_VOICE_TRANSLATION_H_
#define _CONF_VOICE_TRANSLATION_H_

#ifdef _WIN32
#include "zUI/view.h"
#include "zUIClient/zUI_stdafx.h"
#elif defined __MACOS__
#import <zUI/view.h>
#import <zUIClient/zUI_stdafx.h>
#else
#include "view.h"
#include "zUI_stdafx.h"
#endif
#include "zUIClient/zui_client_data_define.h"
#include "zVideoApp/CmmAIInterpretation.h"
#include "zm_conf_universal_ui/zm_conf_universal_ui_interface.h"
#include "zm_conf_universal_ui/zm_conf_uui_ai_interpretation_interface.h"
class CVoiceTranslationDataModel;

class ZUIClient_API ZuiAIInterpretationUniversalUiSink : public NS_ZM_CONF_UNIVERSAL_UI::IAiInterpretationUniversalUiSink
{
public:
  ZuiAIInterpretationUniversalUiSink(CVoiceTranslationDataModel* model);
  virtual ~ZuiAIInterpretationUniversalUiSink();
  
  virtual void OnAIInterpretationStart() override;
  virtual void OnAIInterpretationStop() override;
  virtual void OnAIInterpSpeakingLanguageChanged() override;
  
  virtual void OnTestVoiceStarted() override;
  virtual void OnTestVoiceStopped() override;
  virtual void OnTestVoicePaused() override;
  virtual void OnTestVoiceResumed() override;
  virtual void OnTestVoiceProgressChanged(float progress, CmmInt64 current_time, CmmInt64 duration) override;
  virtual void OnVoiceResourceReadyChanged(bool is_ready) override;
  virtual void OnAIInterpretationVoiceResourceDownloaded(const std::vector<CmmInt32>& list) override;

private:
  CVoiceTranslationDataModel* model_;
};

class ZUIClient_API CVoiceTranslationDataModel : public IInitializable
{
public:
  
  virtual void initializeState() override;
  virtual void initializeStateHandler() override;

  static CVoiceTranslationDataModel& GetInstance();
  CVoiceTranslationDataModel();
  ~CVoiceTranslationDataModel();
  
  void StartOrStopTranslation();
  void UpdateStartState(bool is_started);
  void RefreshSpeakingLanguage();

  zui::State<bool> _startTrans = false;
  zui::State<std::vector<std::string>> _speakingLanguageOptions;
  zui::State<std::vector<std::string>> _languageOptions;
  zui::State<std::vector<std::string>> _voiceOptions;
  zui::State<int> _selectedSpeakingLanguageIndex;
  zui::State<int> _selectedLanguageIndex;
  zui::State<int> _selectedVoiceIndex;
  zui::State<float> _balanceVolume;
  zui::State<bool> _enableCaptions;
  zui::State<bool> _isTestVoicePlaying = false;
  zui::State<bool> _isTestVoicePaused = false;
  zui::State<bool> _isVoiceResourceReady = false;
  zui::State<bool> _isDownloadingVoice = false;
  zui::State<float> _testVoiceProgress = 0.0f;
  zui::State<std::string> _testVoiceTime = std::string("00:00 / 00:00");
  CmmUInt32 _testVoiceHandle = NULL_AUDIO_FILE_HANDLE;
  CmmInt64 _testVoiceDuration = 0;
  
  void CheckVoiceResourceReady();
  void CheckAndDownloadVoiceResource();
  void StartTestVoice();
  void StopTestVoice();
  void PauseTestVoice();
  void ResumeTestVoice();
    
  NS_ZM_CONF_UNIVERSAL_UI::ConfInstParam GetConfInstParam();
  
private:
  void EnsureUuiSinkRegistered(); 
  CmmInt32 GetCurrentVoiceIndex();
  
  std::shared_ptr<ZuiAIInterpretationUniversalUiSink> uui_sink_ = nullptr;
  NS_ZM_CONF_UNIVERSAL_UI::IAiInterpretationUi* last_uui_instance_ = nullptr; 
};

class ZUIClient_API CConfVoiceTranslationView : public zui::CustomView<CConfVoiceTranslationView>
{
public:
  CConfVoiceTranslationView();
  ~CConfVoiceTranslationView() = default;

  std::shared_ptr<zui::View> Clone() const override { return std::make_shared<CConfVoiceTranslationView>(*this); }
  std::shared_ptr<zui::ViewNode> Build() override;
};

#define VoiceTranslationDataModel CVoiceTranslationDataModel::GetInstance()

#endif
