#ifndef _ZUI_CLIENT_MGR_H_
#define _ZUI_CLIENT_MGR_H_

#ifdef _WIN32
#include "zUIClient/zUI_stdafx.h"
#else
#include "zUI_stdafx.h"
#endif
#include "zui_new_setting_event.h"
#include "zUIClient/RecordMeeting/IMRecordMeetingZuiEventHandler.h"
#include "setting_panel_search.h"

#include "cmmlib/CmmPrefBase.h"
#include "cmmlib/CmmPrefConsts.h"
#include "cmmlib/CmmMessageQueueBase.h"
#include "ipt_mgr_hub.h"
#include <memory>

class IZuiVideoMgrHub;
class IPTDialogHub;
class IPTMgrHub;

class ZUIClient_API ZUIClientMgr: public zpref::IPolicyUpdateObserver
{
public:
  static ZUIClientMgr* getInstance();

  ZUIClientMgr(const ZUIClientMgr&) = delete;
  ZUIClientMgr& operator=(const ZUIClientMgr&) = delete;
    
  //> zpref::IPolicyUpdateObserver
  virtual void OnPolicyUpdated(const zpref::zPolicyList& policies) override;

  void InitLanguage(zoom_data::CMM_LANGUAGE_ID_VALUE languageId);
  zoom_data::CMM_LANGUAGE_ID_VALUE GetLanguageID();
  bool IsFullWidthPunctuation();

  void SetNewSettingEventHandler(CZUINewSettingEventHandler* handler);
  CZUINewSettingEventHandler* GetNewSettingEventHandler();

  void SetRecordMeetingEventHandler(IZuiRecordMeetingEventHandler* handler);
  IZuiRecordMeetingEventHandler* GetRecordMeetingEventHandler();

  CSettingSearchDataInterface* GetSettingSearchInterface();

  static void NotifyEvent(ZUIClientSettingEventParam& event);
  static void NotifyEvent(ZUINewSettingEvent event_type);
  static void NotifyEvent(ZUINewSettingEvent event_type, zui::any& wparam);
  static void NotifyEvent(ZuiRecordMeetingEvent event_type, const zui::any& param);

  //> ICmmMessageQueueClient related events
  void DoInitAfterObjCreated(ICmmMessageQueueClient* pMQClient = nullptr);
  void DoUninitBeforeObjDestroyed(ICmmMessageQueueClient* pMQClient = nullptr);

  void InitVideoMgrHub();
  void UninitVideoMgrHub();

  IZuiVideoMgrHub* GetVideoMgrHub() { return video_mgr_hub_; }
  // PT Manager Hub APIs
  IPTMgrHub* GetPTMgrHub();
private:
  ZUIClientMgr() = default;
  ~ZUIClientMgr() = default;

  CZUINewSettingEventHandler* _eventHandler = nullptr;
  IZuiRecordMeetingEventHandler* _recordMeetingHandler = nullptr;

  zoom_data::CMM_LANGUAGE_ID_VALUE _languageId = zoom_data::CMM_LANGUAGE_ID_VALUE::Unknow;

  std::map<ICmmMessageQueueClient*, int> _uuiRegSinkMap;

  IZuiVideoMgrHub* video_mgr_hub_ = nullptr;
  std::unique_ptr<IPTMgrHub> _ptMgrHub;
};

#endif //_ZUI_CLIENT_MGR_H_
