#ifndef __ZUI_VIDEO_MGR_HUB_INTERFACE_H__
#define __ZUI_VIDEO_MGR_HUB_INTERFACE_H__

class IZUIMeetingHostControlMgr;
class IZUIMeetingSettingMgr;
class IZUIMeetingInfoMgr;
class IZUIMeetingEncryptionMgr;

class IZuiVideoMgrBase
{
public:
  virtual ~IZuiVideoMgrBase() {}
  virtual void Init() = 0;
  virtual void Uninit() = 0;
};

class IAlertDialogMgr : public IZuiVideoMgrBase
{
public:
  IAlertDialogMgr() {}
  virtual ~IAlertDialogMgr() {}
};

class IZuiVideoMgrHub : public IZuiVideoMgrBase
{
public:
	virtual ~IZuiVideoMgrHub() {}
	virtual IAlertDialogMgr* GetAlertDialogMgr() = 0;

  virtual IZUIMeetingSettingMgr* GetMeetingSettingMgr() = 0;

  virtual IZUIMeetingHostControlMgr* GetHostControlMgr() = 0;

  virtual IZUIMeetingInfoMgr* GetMeetingInfoMgr() = 0;

  virtual IZUIMeetingEncryptionMgr* GetMeetingEncryptionMgr() = 0;
};

#endif //__ZUI_VIDEO_MGR_HUB_INTERFACE_H__

