//
//  ZMTabsRegisterCenter.h
//  ChatUI
//
//  Created by Kay Fu on 10/30/24.
//  Copyright © 2024 Zoom. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <PTUIBridge/IZMMainTabsData.h>

NS_ASSUME_NONNULL_BEGIN

@interface ZMTabsRegisterCenter : NSObject

+ (instancetype)defaultCenter;

/// Register tab corresponding to the node
/// @param tab data provider
- (void)registerTab:(id<ZMBaseTabsDataProtocol>)tab;

/// Register tab corresponding to the node
/// @param tab data provider
- (void)unregisterTab:(id<ZMBaseTabsDataProtocol>)tab;

- (void)unregisterAllTab;

- (nullable NSArray<id<ZMBaseTabsDataProtocol>> *)getCurrentTabs;

- (nullable id<ZMBaseTabsDataProtocol>)getTabOfIdentifier:(NSString *)identifier;

@end


NS_ASSUME_NONNULL_END
