//
//  ZMSettingMgr+Private.h
//  ZoomSetting
//
//  Created by Lester.Gong on 2025/1/27.
//

#import <ZoomSetting/ZMSettingMgr.h>

NS_ASSUME_NONNULL_BEGIN

@class ZMSettingItemViewController;

@interface ZMSettingMgr (Private)

- (void)quitSearching:(BOOL)clearSearchField;
- (NSInteger)suitableWindowLevel;
- (void)upgradeVersion;
- (void)turnOffMediaDevice;
- (void)scheduleCheckingOcclusionState;
- (void)cancelCheckingOcclusionState;
- (void)selectionDidChangeFrom:(__kindof ZMSettingItemViewController*)previousSelectedItem
                           to:(__kindof ZMSettingItemViewController*)newSelectedItem;
- (void)windowWillAppear;
- (void)windowDidAppear;
- (void)windowDidActivate;
- (BOOL)windowWillClose;//If the window is loaded and visible before closing, YES is returned
- (void)windowDidClose:(BOOL)windowLoadedAndVisibleBeforeClosing;
- (void)onCleanUp;
- (void)createPhoneItemIfNeeded;

@end

NS_ASSUME_NONNULL_END

