/**
 * @file container.h
 * @brief Base container component
 * 
 * Provides base container functionality for layout components.
 */

#pragma once

#include <memory>
#include "helper.h"
#include "view.h"

namespace zui
{
	// forward declaration
	class ContainerNode;

	/**
	 * @class Container
	 * @brief Base class for container components.
		 */
	class ZUI_API Container : public View
	{
	public:
		template<typename... Views>
		Container(View::Type viewType, std::function<std::shared_ptr<ViewNode>()> builder, Views&&... views)
			: View(viewType, builder)
		{
			int dummy[] = { 0, (AddChildView(views.GetViewNode()), 0)... };
			static_cast<void>(dummy); // Prevent unused variable warning
		}

		~Container() = default;

		Container& spacing(float spacing);
		Container& alignItems(Layout::Alignment alignment);

	private:
		void AddChildView(std::shared_ptr<ViewNode> viewNode);
	};

namespace p
{

  class ZUI_API spacing : public PipeModifier
  {
  public:
    explicit spacing(float spacing);
    ~spacing();
  protected:
    void apply(View& v) const override;
  private:
    class Impl;
    Impl* _pImpl;
  };

  class ZUI_API containerAlignItems : public PipeModifier
  {
  public:
    explicit containerAlignItems(Layout::Alignment alignment);
    ~containerAlignItems();
  protected:
    void apply(View& v) const override;
  private:
    class Impl;
    Impl* _pImpl;
  };

  namespace discover {
    namespace by_view {
      namespace container {
        using zui::p::spacing;
        using zui::p::containerAlignItems;
      }
    }
  }

} // namespace p

}

