/**
 * @file list.h
 * @brief List container component
 * @ingroup zui_container_views
 * 
 * Provides list container functionality for displaying collections of items.
 */

#pragma once

#include <functional>
#include <memory>
#include "zui_data_define.h"
#include "view.h"
#include <vector>

namespace zui
{

	/**
	 * @class List
	 * @brief A container for displaying collections of items.
	 * @ingroup controls_grouping
	 */
	class ZUI_API List : public View
	{
	public:
		template<typename... T,
			typename = typename std::enable_if<zui::conjunction<std::is_base_of<View, T>...>::value>::type>
			List(T&&... views)
			: View(View::Type::List, [this]() {
        return (this)->BuildList();
    })
		{
			int dummy[] = { 0, (AddChildView(std::forward<T>(views)), 0)... };
			static_cast<void>(dummy); // Prevent unused variable warning
		}

		List(const Bind<std::vector<zui::any>>& data);
		virtual ~List() = default;

		List& cell(const std::function<std::shared_ptr<View>(zui::any& cellData, size_t index)>& cellFunc);
		List& cellHeight(float cellHeight);
		List& cellPadding(const Layout::EdgeInsets& cellPadding);
    
    std::shared_ptr<ViewNode> BuildList();


	private:
		void AddChildView(View& viewNode);
	};

namespace p
{

  // List-specific pipe modifiers
  class ZUI_API listCell : public PipeModifier
  {
  public:
    explicit listCell(const std::function<std::shared_ptr<View>(zui::any& cellData, size_t index)>& cellFunc);
    ~listCell();
  protected:
    void apply(View& v) const override;
  private:
    class Impl;
    Impl* _pImpl;
  };

  class ZUI_API listCellHeight : public PipeModifier
  {
  public:
    explicit listCellHeight(float cellHeight);
    ~listCellHeight();
  protected:
    void apply(View& v) const override;
  private:
    class Impl;
    Impl* _pImpl;
  };

  class ZUI_API listCellPadding : public PipeModifier
  {
  public:
    explicit listCellPadding(const Layout::EdgeInsets& cellPadding);
    ~listCellPadding();
  protected:
    void apply(View& v) const override;
  private:
    class Impl;
    Impl* _pImpl;
  };

  namespace discover {
    namespace by_view {
      namespace list {
        using zui::p::listCell;
        using zui::p::listCellHeight;
        using zui::p::listCellPadding;
      }
    }
  }

} // namespace p

}
