/**
 * @file loop.h
 * @brief Loop logic component
 * @ingroup zui_logic_views
 * 
 * Provides loop rendering functionality for dynamic content generation.
 */

#ifndef _ZUI_LOOP_H_
#define _ZUI_LOOP_H_

#include <functional>
#include <memory>
#include <vector>
#include "container.h"

namespace zui
{
	/**
	 * @class Loop
	 * @brief A view component for rendering collections of data.
	 * @ingroup controls_logic
	 */
	class ZUI_API Loop : public View
	{
	public:
		explicit Loop(const Bind<std::vector<zui::any>>& range);

		virtual ~Loop() = default;

		/**
		* @brief Set up a view for loop creation.
		* @param[in] view
		*/
		Loop& body(const std::function<std::shared_ptr<View>(zui::any& val)>& func);
        Loop& body(const std::function<View(zui::any& val)>& func);
        
    protected:
        std::function<std::shared_ptr<View>(zui::any&)> BuildBody(const std::function<View(zui::any& val)>& func);

	};

	/**
	 * @class ListLoop
	 * @brief A specialized loop view with accessibility features similar to list(Windows only currently)
	 * @ingroup controls_logic
	 */
	class ZUI_API ListLoop : public Loop
	{
	public:
		ListLoop(const Bind<std::vector<zui::any>>& range);
	};

namespace p
{

  // Loop-specific pipe modifiers
  class ZUI_API loopBody : public PipeModifier
  {
  public:
    explicit loopBody(const std::function<std::shared_ptr<View>(zui::any& val)>& func);
    explicit loopBody(const std::function<View(zui::any& val)>& func);
    ~loopBody();
  protected:
    void apply(View& v) const override;
  private:
    class Impl;
    Impl* _pImpl;
  };

  namespace discover {
    namespace by_view {
      namespace loop {
        using zui::p::loopBody;
      }
    }
  }

} // namespace p

}

#endif
