#ifndef ZUI_MEETING_ENCRYPTION_H
#define ZUI_MEETING_ENCRYPTION_H

#ifdef _WIN32
#include "zUI/view.h"
#include "zUIClient/zUI_stdafx.h"
#elif defined __MACOS__
#import <zUI/view.h>
#import <zUIClient/zUI_stdafx.h>
#else
#include "view.h"
#include "zUI_stdafx.h"
#endif

class IZUIMeetingEncryptionSink
{
public:
  virtual ~IZUIMeetingEncryptionSink() = default;

  virtual void OnClickReportProblem() = 0;
  virtual void OnClickSecuritySetting() = 0;

  virtual void OnEncryptionShow() {}
  virtual void OnEncryptionSizeChanged(int width, int height) {}
  virtual void OnEncryptionHide() {}

  virtual void OnEncryptionActiveChanged(bool active) {}
  virtual void OnEncryptionMouseHoverChanged(bool hovered) {}
};

class ZUIClient_API IZUIMeetingEncryptionMgr
{
public:
  enum class Page
  {
    kMainInfo,
    kSecurityCode,
    kException,
  };

public:
  virtual ~IZUIMeetingEncryptionMgr() = default;

  virtual void ShowEncryptionInfo(void* parent = nullptr) = 0;
  virtual void HideEncryptionInfo() = 0;
  virtual void CloseEncryptionInfo() = 0;
  virtual void UpdatePosition(int x, int y) = 0;
  virtual bool IsEncryptionInfoVisible() = 0;

  virtual bool IsWindowMouseHovered() { return false; };

  virtual void SetSink(IZUIMeetingEncryptionSink* sink) = 0;
  virtual void* GetWindowHandle() = 0;
  virtual Layout::Rect GetWindowGeometry() = 0;

  virtual void UpdateData() = 0;
  virtual void SwitchToMainPage() = 0;

  virtual void SetPage(IZUIMeetingEncryptionMgr::Page page) = 0;
  virtual void SetDefaultPage(IZUIMeetingEncryptionMgr::Page page) = 0;
  virtual IZUIMeetingEncryptionMgr::Page GetCurrentPage() = 0;
  virtual bool IsCurrentPage(IZUIMeetingEncryptionMgr::Page page) = 0;
};

#endif // ZUI_MEETING_ENCRYPTION_H
