//
//  TVPINSingleDigitNumberFormatter.h
//  BoinxTV
//
//  Created by Alexander Lehnert on 17.06.13.
//  Copyright (c) 2013 Boinx Software Ltd. All rights reserved.
//

@protocol BXDigitLengthNumberFormatterDelegate;


/** Allows filitering the amount of digits.
 */
@interface BXDigitLengthNumberFormatter : NSNumberFormatter
{
    id<BXDigitLengthNumberFormatterDelegate> _delegate;
    NSUInteger _maximumLength;
}

@property (nonatomic, assign, readwrite) id<BXDigitLengthNumberFormatterDelegate> delegate;
@property (nonatomic, readwrite) NSUInteger maximumLength;

@end


#pragma mark - Callbacl

/** Callback interface allows to get events from the Formatter about string validation
 
 Use this protcoll to detect paste operation with invalid string lengths 
 */
@protocol BXDigitLengthNumberFormatterDelegate<NSObject>

@required

/** Called if the partial string thta should be inserted is out of the given maximumLength of the formatter
 */
- (void)digitLengthFormatter:(BXDigitLengthNumberFormatter *)formatter detectString:(NSString *)string exceedingMaxLength:(NSUInteger)maxLength;

@end
