/*
 
 Owner: Leon von Tippelskirch <leon@boinx.com>
 Company: Boinx Software Ltd., Germany
 Projects: BXEssentialKeyStorage
 
 Abstract: Handles all additional functionality in the BXLicenseController for the Mac AppStore.
 
 */

#import <BXEssentialKeyStorage/BXLicenseController.h>
#import <BXFoundation/BXMacros.h>
#import <BXFoundation/BXLog.h>

#define APPSTORE_CHECK_FRACTION 10

#import <IOKit/IOKitLib.h> 
#import <Foundation/Foundation.h> 
#import <Security/Security.h> 
#import <Security/CSCommon.h> 
#import <Security/SecCode.h> 
#import <Security/SecStaticCode.h> 
//#import <Security/SecCodeHost.h> 
#import <Security/SecRequirement.h> 

#pragma mark C Function definition

CFDictionaryRef dictionaryWithAppStoreReceiptAtPath(NSString *path);
CFArrayRef parseInAppPurchasesData(NSData *inAppData);
CFDataRef copyMacAddress(void);
BOOL isAppleSignedBinary(NSURL *filePath);
BOOL checkForValidReceipt(void);
BOOL isAppStore(void);
void exitWithInvalidCert(void);

@interface BXLicenseControllerAppStore : BXLicenseController
{
}

// overridden functions
- (BOOL)hasLicense;
- (BOOL)needsToRegister;
- (BOOL)isLicensed;
- (int)licenseStatus;
- (BOOL)isAppStore;

@end



