//**********************************************************************************************************************
//
//  BXPathUtils.h
//
//  Author:		Peter Baumgartner, peter@baumgartner.com
//  Copyright:	©2011 by Boinx Software, Ltd. All rights reserved.
//	Abstract:	Various file related utils
//
//**********************************************************************************************************************


#if defined(__cplusplus)
extern "C" {
#endif

#if ! TARGET_OS_IPHONE
NSString * BXUtiForExtension(NSString *inExtension);            // was +[BXPathUtils utiForExtension:]
#endif
#ifdef __cplusplus
}
#endif	


//----------------------------------------------------------------------------------------------------------------------


// The following category assumes that the string contains a path to a file or folder...

@interface NSString (BXPathUtils)

- (NSNumber *) fileSize;                                        // was +[BXPathUtils fileSizeAtPath:];
- (NSNumber *) freeDiskSpaceInBytes;                            // was +[BXPathUtils freeDiskBytesForFolder:]
- (NSString *) volumeName;
- (NSString *) uti;                                             // was +[BXPathUtils utiForPath:]

- (NSString *) pathByResolvingSymlinksAndAliases;               // was +[BXPathUtils resolvedPath:]

#if ! TARGET_OS_IPHONE				// only on Mac, use NSTemporaryDirectory() on iOS
- (NSString *) pathToTempFolderOnSameVolume;                    // was +[BXPathUtils tempFolderForPath:]
#endif

- (BOOL) fileExists;                                            // was +[BXPathUtils fileExists:]
- (BOOL) isRelativePath;                                        // was +[BXPathUtils isRelativePath:]

@end


// Corresponding methods for NSURL...

@interface NSURL (BXPathUtils)

- (NSNumber *) fileSize;
- (NSNumber *) freeDiskSpaceInBytes;  
- (NSString *) volumeName;
- (NSString *) uti;

- (NSURL *) URLByResolvingSymlinksAndAliases;

#if ! TARGET_OS_IPHONE				// only on Mac, use NSTemporaryDirectory() on iOS
- (NSURL *) URLToTempFolderOnSameVolume;
#endif

- (BOOL) fileExists; 
- (BOOL) isRelativePath; 

@end


//----------------------------------------------------------------------------------------------------------------------


// This category assumes that the number contains a number of bytes...

@interface NSNumber (BXPathUtils)

- (NSString*) byteSizeString;                                   // was +[BXPathUtils sizeStringFromBytes:]

@end


//----------------------------------------------------------------------------------------------------------------------


@interface NSFileManager (BXPathUtils)

+ (NSFileManager *) threadSafeFileManager;                      // use instead of defaultManager

- (NSString *) absolutePathWithBasePath:(NSString *)inBasePath relativePath:(NSString *)inRelativePath; // was in BXPathUtils
- (NSString *) relativePathWithBasePath:(NSString *)inBasePath absolutePath:(NSString *)inAbsolutePath; // was in BXPathUtils
- (NSString *) uniquePathForProposedPath:(NSString *)inPath;

@end


//----------------------------------------------------------------------------------------------------------------------
