//**********************************************************************************************************************
//
//  NSObject+CoalescedPerform.h
//
//  Author:		Peter Baumgartner, peter@baumgartner.com
//  Copyright:	©2006-2011 by IMAGINE GbR. All rights reserved.
//	Abstract:	Category that coalesces perform requests to a method the next time through the runloop
//
//**********************************************************************************************************************


@interface NSObject (BXCoalescedPerform)

// Convenience method for performing a delayed selector. No coalescing here...

- (void) performDelayedSelector:(SEL)inSelector withObject:(id)inObject;

// Use the following methods to coalesce multiple perform requests to a given methods to a single invocation 
// the next time throught the runloop. The second method includes a delay to increase the coalescing interval...

- (void) performCoalescedSelector:(SEL)inSelector;
- (void) performCoalescedSelector:(SEL)inSelector withObject:(id)inObject;
- (void) performCoalescedSelector:(SEL)inSelector withObject:(id)inObject afterDelay:(double)inDelay;

// Cancel a given delayed selector...

- (void) cancelDelayedSelector:(SEL)inSelector withObject:(id)inObject;

// Cancel all delayed selectors. Highly recommended to call this method in all dealloc method...

- (void) cancelAllDelayedSelectors;

@end


//----------------------------------------------------------------------------------------------------------------------


// Convenience function to get an array of common runloop modes...

#define BX_COMMON_RUNLOOP_MODES [NSArray arrayWithObject:NSRunLoopCommonModes]
	
	
//----------------------------------------------------------------------------------------------------------------------
