//
//  ZMPTSinkProtocol.h
//  PTUIBridge
//
//  Created by fistice on 2024/10/25.
//

#ifndef ZMPTSinkProtocol_h
#define ZMPTSinkProtocol_h

#include <zPTApp/SaasBeePTAppInterface.h>

@protocol ZMPTSinkProtocol <NSObject>
@optional
- (void)initModule;
- (void)sinkMeetingEvent:(PT_MEETING_EVENT)ptEvent result:(CmmUInt32)result content:(void *)content;
- (void)sinkIPCEvent:(PT_IPC_EVENT)ptEvent result:(CmmUInt32)result content:(void *)content;
- (void)sinkAppEvent:(PT_EVENT)ptEvent result:(CmmUInt32)result content:(void *)content;
- (void)sinkIMEvent:(PT_IM_EVENT)ptEvent result:(CmmUInt32)result content:(void *)content;

- (void)onZpnsCommonSidepanelReceived;
- (void)onAICompanionSettingUpdate;
- (void)onBillingStatusPushReceived;
- (void)onZpnsCommandClearListReceived:(const std::map<CString, std::vector<CString>>&)clear_list;
- (void)onZpnsCommonToastReceived:(const std::vector<CmmZpnsToast>&) toast_vec;
- (void)onZpnsCommonCoachmarkReceived:(const std::vector<CmmZpnsCoachmark>&) vec_coachmarks;
- (void)onZpnsCommonCoachmarkUpdated:(const CmmZpnsCoachmark&) coachmark;
- (void)onZpnsAICSidePanelUpdated;
- (void)notifyUnKnownURLScheme;
- (void)onNeedForceUpgrade:(const UpdateAppParam&)param;
- (void)onNeedSoftUpgrade:(const UpdateAppParam&)param;
- (void)onRevokeXmppToken:(const CString&)reqID
                   result:(CmmUInt32)result;
- (BOOL)sinkRingtoneCheckUpdate:(const CString &)latestVersion
                    downloadURL:(const CString &)downloadURL
                    releaseNote:(const CString &)releaseNote
                      requestID:(const CString &)requestID
                         result:(CmmUInt32)result;
- (void)onRecaptchaRequest:(const SB_webservice::RecaptchaInfo&)info;

// ASR Download Events
- (void)notifyToCheckUpdateASRLibrary;
- (void)notifyToCheckUpdateASRModels:(const asr_model_download_infos&)models;
- (void)notifyToPauseAllDownloadingASRModels;
- (void)onDownloadingFileByUrl:(const CString&)requestID localFilePath:(const CString&)localFilePath result:(CmmUInt32)result;

- (void)onGetNoAuthNumberOfMeetingsV2Response:(const RequestMarketingDialogInfoParam&)response requestID:(const CString&)requestID;

@end
#endif /* ZMPTSinkProtocol_h */
