//
//  ZMPopOutWindowMgr.h
//  ChatUI
//
//  Created by Kay Fu on 2023/12/26.
//  Copyright © 2023 Zoom. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "ZMPopOutWindowMgrDefine.h"
#import <PTUIBridge/ZMTabDefineHeader.h>
#import <ZoomUnit/ZoomUnit-Swift.h>

NS_ASSUME_NONNULL_BEGIN

@interface ZMPopOutWindow : NSWindow <ZMPopOutMergeBackViewEvent, ZMToastCoordinatorProvider>

@property (nonatomic,assign) ZMMainTabsType moduleType;

@property (nonatomic,copy) NSString *zmIdentifier;

@property (nonatomic,strong) ZMToastCoordinator *toastCoordinator;


- (void)showLoading;
- (void)dismissLoading;

@end

@interface ZMPopOutWindowMgr : NSObject

+ (ZMPopOutWindowMgr*)sharedInstance;

- (nullable NSView<ZMPopOutMergeBackViewProtocol> *)popView:(NSView *)view atModule:(ZMMainTabsType)module identifier:(NSString *)identifier param:(NSDictionary *)param;

- (nullable ZMPopOutWindow *)mergeBackAtModule:(ZMMainTabsType)module identifier:(NSString *)identifier param:(NSDictionary *)param;

- (BOOL)popUrl:(NSString *)url atModule:(ZMMainTabsType)aModule param:(NSDictionary *)param;

- (void)registMaxPopoutCount:(NSInteger)maxCount atModule:(ZMMainTabsType)aModule;

- (NSInteger)getMaxPopoutCountOfModule:(ZMMainTabsType)aModule;

- (void)bringPopOutWindowToFrondOfModule:(ZMMainTabsType)theModule;

- (BOOL)isPoppedOfModule:(ZMMainTabsType)theModule;

- (BOOL)isPoppedOfModule:(ZMMainTabsType)theModule identifier:(NSString *)identifier;

- (NSInteger)getPoppedCountOfModule:(ZMMainTabsType)theModule;

- (ZMPopOutWindow *)getPoppedWindowOfModule:(ZMMainTabsType)theModule identifier:(NSString *)identifier;

- (NSString *)getWebViewIdFromUrl:(NSString *)url;

- (void)didLogout;

@end

NS_ASSUME_NONNULL_END
